package com.ibm.lab.soln.sqleditor.utils;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.jface.text.rules.IWordDetector;

import com.ibm.lab.soln.sqleditor.sql.ISQLSyntax;

/**
 * Determines whether a given character is valid as part of an SQL keyword in 
 * the current context.
 */
public class SQLWordDetector implements IWordDetector, ISQLSyntax {

	/**
	 * @see org.eclipse.jface.text.rules.IWordDetector#isWordStart(char)
	 */
	public boolean isWordStart(char c) {
		for (int i = 0; i < reservedwords.length; i++)
			if (((String) reservedwords[i]).charAt(0) == c)
				return true;

		for (int i = 0; i < types.length; i++)
			if (((String) types[i]).charAt(0) == c)
				return true;

		for (int i = 0; i < constants.length; i++)
			if (((String) constants[i]).charAt(0) == c)
				return true;
		return false;
	}

	/**
	 * @see org.eclipse.jface.text.rules.IWordDetector#isWordPart(char)
	 */
	public boolean isWordPart(char c) {
		for (int i = 0; i < reservedwords.length; i++)
			if (((String) reservedwords[i]).indexOf(c) != -1)
				return true;

		for (int i = 0; i < types.length; i++)
			if (((String) types[i]).indexOf(c) != -1)
				return true;

		for (int i = 0; i < constants.length; i++)
			if (((String) constants[i]).indexOf(c) != -1)
				return true;

		return false;
	}

}
