package com.ibm.lab.soln.sqleditor;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;

import com.ibm.lab.soln.sqleditor.utils.ColorProvider;

import java.util.*;

/**
 * The main plugin class.
 */
public class SQLEditorPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static SQLEditorPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	ColorProvider colorProvider;

	/**
	 * The constructor.
	 */
	public SQLEditorPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle =
				ResourceBundle.getBundle(
					"com.ibm.lab.soln.sqleditor.SQLEditorPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		colorProvider = new ColorProvider();

	}

	/**
	 * Returns the shared instance of the Plugin.
	 */
	public static SQLEditorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle =
			SQLEditorPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	public void disposeColorProvider() {
		colorProvider.dispose();

	}

	/**
	 * Returns the colorProvider.
	 * @return ColorProvider
	 */
	public ColorProvider getColorProvider() {
		return colorProvider;
	}

}
