package com.ibm.lab.soln.swing.internalLaunch.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorLauncher;

/**
 * Class that opens the ABCEditor on the Eclipse input file
 * 
 */
public class ABCEditorLauncher implements IEditorLauncher {

	/**
	 * Opens the ABCEditor on *.abc files in the Eclipse workspace.
	 * 
	 * @see org.eclipse.ui.IEditorLauncher#open(IFile)
	 */
	public void open(IFile file) {
		System.out.println( 
			"Launch Successful : file Location = "
				+ file.getLocation().toString());
		SwingEditorPlugin.getDefault().getAbcEditor().openOnEclipseFile(file);

	}

}
