package com.ibm.lab.soln.msseditor.ui.wizards;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/**
 * Specialization of the new file creation processing that adds
 * fields to initialize the number of rows and columns in the new
 * mini-spreadsheet.
 */
public class NewMiniSpreadsheetWizard extends Wizard implements INewWizard {
	IStructuredSelection selection;
	MiniSpreadsheetWizardNewFileCreationPage fileCreationPage;
	IWorkbench workbench;

	/**
	 * Constructor for NewMiniSpreadsheetWizard.
	 */
	public NewMiniSpreadsheetWizard() {
		super();
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		return fileCreationPage.finish();
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
		setWindowTitle("New Mini-Spreadsheet");
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {
		fileCreationPage =
			new MiniSpreadsheetWizardNewFileCreationPage(workbench, selection);
		addPage(fileCreationPage);
	}
}
