package com.ibm.lab.soln.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetEditor;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetUIPlugin;

/**
 * Coordinate the addition of actions on behalf the mini-spreadsheet editor.
 */
public class MiniSpreadsheetEditorActionBarContributor
	extends EditorActionBarContributor implements ISelectionChangedListener {
		
	MiniSpreadsheetEditor editor;
	ArrayList actions = new ArrayList();
	
	MiniSpreadsheetEditorAction alignLeftAction;
	MiniSpreadsheetEditorAction alignCenterAction;
	MiniSpreadsheetEditorAction alignRightAction;
	MiniSpreadsheetEditorAction removeAction;
	MiniSpreadsheetEditorAction clearAllAction;
	MiniSpreadsheetEditorAction showTotalAction;

	/**
	 * @see org.eclipse.ui.part.EditorActionBarContributor#contributeToToolBar(IToolBarManager)
	 */
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		toolBarManager.add(alignLeftAction);
		toolBarManager.add(alignCenterAction);
		toolBarManager.add(alignRightAction);
		toolBarManager.add(new Separator());
		toolBarManager.add(clearAllAction);
		toolBarManager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	protected void createActions() {
		alignLeftAction = 
			new ChangeAlignmentAction("align.left", SWT.LEFT);
		alignCenterAction = 
			new ChangeAlignmentAction("align.center", SWT.CENTER);
		alignRightAction = 
			new ChangeAlignmentAction("align.right", SWT.RIGHT);

		ChangeAlignmentAction caActions[] = new ChangeAlignmentAction[3];
		caActions[0] = (ChangeAlignmentAction) alignLeftAction;
		caActions[1] = (ChangeAlignmentAction) alignCenterAction;
		caActions[2] = (ChangeAlignmentAction) alignRightAction;

		caActions[0].setGroup(caActions);
		caActions[1].setGroup(caActions);
		caActions[2].setGroup(caActions);

		removeAction = new RemoveRowAction();
		clearAllAction = new ClearAllAction();		
		showTotalAction = new ShowTotalAction();
		
		actions.add(alignLeftAction);
		actions.add(alignCenterAction);
		actions.add(alignRightAction);		
		actions.add(removeAction);
		actions.add(clearAllAction);
		actions.add(showTotalAction);		
	}

	public void contributeToMenu(IMenuManager menuManager) {
		MenuManager menu =
			new MenuManager(
				"&Calculations", MiniSpreadsheetUIPlugin.getId()+ ".calculations");

		menuManager.insertAfter(IWorkbenchActionConstants.MB_ADDITIONS, menu);
		menu.add(showTotalAction);
		menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	/**
	 * @see org.eclipse.ui.part.EditorActionBarContributor#setActiveEditor(IEditorPart)
	 */
	public void setActiveEditor(IEditorPart targetEditor) {
		if (editor != null)
			editor.getSite().getSelectionProvider().
				removeSelectionChangedListener(this);
		editor = (MiniSpreadsheetEditor) targetEditor;
		if (editor != null)
			editor.getSite().getSelectionProvider().
				addSelectionChangedListener(this);
		
		for (Iterator iter = actions.iterator(); iter.hasNext();) {
			MiniSpreadsheetEditorAction action = (MiniSpreadsheetEditorAction) iter.next();
			action.setActiveEditor(editor);
		}
		
		selectionChanged(new SelectionChangedEvent(editor.getSite().getSelectionProvider(),
			editor.getSite().getSelectionProvider().getSelection()));
	}

	/**
	 * @see org.eclipse.ui.part.EditorActionBarContributor#init(IActionBars, IWorkbenchPage)
	 */
	public void init(IActionBars bars, IWorkbenchPage page) {
		createActions();

		super.init(bars, page);

		bars.setGlobalActionHandler(
			IWorkbenchActionConstants.DELETE,
			removeAction);
	}
	
	/**
	 * @see org.eclipse.ui.IEditorActionBarContributor#dispose()
	 */
	public void dispose() {
		if (editor != null)
			editor.getSite().getSelectionProvider().
				removeSelectionChangedListener(this);
	}
		
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		// currently not used, but will leave for future actions.
		for (Iterator iter = actions.iterator(); iter.hasNext();) {
			MiniSpreadsheetEditorAction action = (MiniSpreadsheetEditorAction) iter.next();
			action.selectionChanged((IStructuredSelection) event.getSelection());
		}		
	}
}
