package com.ibm.lab.soln.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.dialogs.MessageDialog;

import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetImages;

/**
 * Action to clear all rows in the mini-spreadsheet.
 */
public class ClearAllAction extends MiniSpreadsheetEditorAction {

	public ClearAllAction() {
		super();

		this.setToolTipText("Clear All");
		this.setId("#ClearAll");
		this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_CLEAR_ALL);
	}

	public void run() {
		if (MessageDialog.openConfirm(null,
				"Clear All","About to clear the entire table. Continue?")) {
			editor.getMiniSpreadsheet().clearAll();
		}
	}
}
