package com.ibm.lab.soln.msseditor.ui;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;

/**
 * Convenience class for the UI plug-in's image descriptors.
 */
public class MiniSpreadsheetImages {
	private static final URL INSTALL_URL =
		MiniSpreadsheetUIPlugin.getDefault().getDescriptor().getInstallURL();
	public static final ImageDescriptor IMAGE_ALIGN_LEFT;
	public static final ImageDescriptor IMAGE_ALIGN_CENTER;
	public static final ImageDescriptor IMAGE_ALIGN_RIGHT;
	public static final ImageDescriptor IMAGE_SPREADSHEET;	
	public static final ImageDescriptor IMAGE_CLEAR_ALL;		

	static {
		IMAGE_ALIGN_LEFT = createImageDescriptor("icons/align_left.gif");
		IMAGE_ALIGN_CENTER = createImageDescriptor("icons/align_center.gif");
		IMAGE_ALIGN_RIGHT = createImageDescriptor("icons/align_right.gif");
		IMAGE_SPREADSHEET = createImageDescriptor("icons/spreadsheet.gif");		
		IMAGE_CLEAR_ALL = createImageDescriptor("icons/clear_all.gif");		
	}

	private static ImageDescriptor createImageDescriptor(String path) {
		try {
			URL url = new URL(INSTALL_URL, path);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
		}
		return ImageDescriptor.getMissingImageDescriptor();
	}
}
