package com.ibm.lab.soln.msseditor.ui;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

import com.ibm.lab.soln.msseditor.core.IMiniSpreadsheetListener;
import com.ibm.lab.soln.msseditor.core.MiniSpreadsheet;

/**
 * Mediate between the table viewer's requests for data and the
 * underlying mini-spreadsheet model.
 */
public class MiniSpreadsheetContentProvider
	implements IStructuredContentProvider, IMiniSpreadsheetListener {
	TableViewer tableViewer;
	MiniSpreadsheet miniSpreadsheet;

	/**
	 * Constructor for MiniSpreadsheetContentProvider.
	 */
	public MiniSpreadsheetContentProvider() {
		super();
	}

	/**
	 * Return all rows, the label provider will handle mapping them into strings.
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(Object)
	 * @see com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetLabelProvider
	 */
	public Object[] getElements(Object inputElement) {
		return ((MiniSpreadsheet) inputElement).getRows();
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		if (miniSpreadsheet != null) {
			miniSpreadsheet.removeMiniSpreadsheetListener(this);
			miniSpreadsheet = null;
		}
	}

	/**
	 * When the input changes, re-establish model change listening.
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(Viewer, Object, Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		tableViewer = (TableViewer) viewer;
		if (miniSpreadsheet != null) {
			miniSpreadsheet.removeMiniSpreadsheetListener(this);
		}

		miniSpreadsheet = (MiniSpreadsheet) newInput;
		if (miniSpreadsheet != null) {
			miniSpreadsheet.addMiniSpreadsheetListener(this);
		}
	}

	/**
	 * The model has changed, inform the view.
	 * 
	 * @see com.ibm.lab.soln.msseditor.core.IMiniSpreadsheetListener#valueChanged(MiniSpreadsheet, int, int, String)
	 */
//	Edu-Sol : 11b Synch Editor content and model (source)
	public void valueChanged
			(MiniSpreadsheet miniSpreadsheet, int row, int column, String newValue) {
		tableViewer.cancelEditing();
		
		// treat the column number as a property, since this is a generic table with n-columns.
		// (add one since the first column is the row numbers).
		tableViewer.update(
			miniSpreadsheet.getRows()[row],
			new String[] { Integer.toString(column+1)});
	}
	
	/**
	 * The model has changed, inform the view.
	 * 
	 * @see com.ibm.lab.soln.msseditor.core.IMiniSpreadsheetListener#rowsChanged(MiniSpreadsheet)
	 */
//	Edu-Sol : 11c Synch Editor content and model (source)
	public void rowsChanged(MiniSpreadsheet miniSpreadsheet) {
		tableViewer.cancelEditing();		
		tableViewer.refresh();
	}
}
