package com.ibm.lab.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.Iterator;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;

/**
 * Action to remove the selected row(s) from the mini-spreadsheet.
 */
public class RemoveRowAction
	extends MiniSpreadsheetEditorAction
	implements ISelectionChangedListener {

	public RemoveRowAction() {
		super();

		this.setText("&Remove");
		this.setId("#Remove");
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IStructuredSelection sel =
			(IStructuredSelection) editor.getSite().
				getSelectionProvider().getSelection();
		if (sel.isEmpty())
			return;

		for (Iterator iter = sel.iterator(); iter.hasNext();) {
			MiniSpreadsheetRow msr = (MiniSpreadsheetRow) iter.next();
			msr.remove();
		}
	}

	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		setEnabled(!event.getSelection().isEmpty());
	}
}
