package com.ibm.lab.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.swt.SWT;

import com.ibm.lab.msseditor.ui.MiniSpreadsheetEditor;
import com.ibm.lab.msseditor.ui.MiniSpreadsheetImages;

/**
 * Action to change the column alignment of the mini-spreadsheet editor.
 */
public class ChangeAlignmentAction extends MiniSpreadsheetEditorAction {
	int alignment;
	ChangeAlignmentAction[] group;

	public ChangeAlignmentAction(String id, int newAlignment) {
		this.alignment = newAlignment;
		this.setId(id);

		if (newAlignment == SWT.LEFT) {
			this.setToolTipText("Align All Left");
			this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_LEFT);
		}
		else if (newAlignment == SWT.CENTER) {
			this.setToolTipText("Align All Center");
			this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_CENTER);
		}			
		else {
			this.setToolTipText("Align All Right");
			this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_RIGHT);
		}			
	}

	public int getStyle() {
		return AS_CHECK_BOX;
	}

	public void run() {
		editor.setAlignment(alignment);
		update();
	}

	private void update() {
		for (int i = 0; i < group.length; i++) {
			group[i].setChecked(editor.getDefaultAlignment() == group[i].alignment);
		}
	}

	public void setActiveEditor(MiniSpreadsheetEditor editor) {
		super.setActiveEditor(editor);
		update();
	}

	public void setGroup(ChangeAlignmentAction[] group) {
		this.group = group;
	}
}
