package com.ibm.lab.usingjdt.threadeddebugging;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

/**
 * Class <code>PrimeFactorialGenerator</code> generates a series of prime
 * factorials starting with 2. The class is used in a number of the exercises in
 * Chapters 29 and 30 to illustrate different capabilities of the Java
 * Development Tools (JDT). 
 */
public class PrimeFactorialGenerator extends NumberGenerator {
	
	/**
	 * Method <code>generateNumbers</code> generates <code>quantity</code> prime factorials.
	 */
	public void generateNumbers() {
		PrimeNumberGenerator primes = new PrimeNumberGenerator();
		primes.setQuantity(getQuantity());
		primes.generateNumbers();
		Object[] numbers = new Object[primes.getResults().length];
		int factorial = 1;
		for (int i = 0; i < primes.getResults().length; i++) {
			factorial = factorial * 
				((Integer) primes.getResults()[i]).intValue();
			numbers[i] = new Integer(factorial);
		}
		setResults(numbers);
	}
}
