package com.ibm.lab.usingjdt.threadeddebugging;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

/**
 * Class <code>DebuggingExampleThreaded</code> is a simple class used in the
 * exercise in Part 2 of Chapter 30 to drive <code>PrimeNumberGenerator</code>
 * to illustrate debugging multithreaded programs.
 */
public class DebuggingExampleThreaded {

	/**
	 * Method <code>main</code> drives class <code>PrimeNumberGenerator</code>
	 * to illustrate multi-threaded debugging with JDT.
	 * @param args
	 */
	public static void main(String[] args) {
		int threadCount = new Integer(args[0]).intValue();
		for (int i = 0; i < threadCount; i++) {
			PrimeNumberGenerator p = new PrimeNumberGenerator();
			p.setQuantity(10);
			p.start();
		}
	}
}
