package com.ibm.lab.usingjdt.quickfix;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

/**
 * Class <code>PrimeNumberGenerator</code> generates a series of prime numbers
 * starting with 2. The class is used in a number of the exercises in Chapters
 * 29 and 30 to illustrate different capabilities of the Java Development Tools
 * (JDT). Several versions of this class exist in different packages in this
 * project and in packages in other projects. These different versions are used
 * in the different parts of the exercises in chapters 29 and 30.
 * 
 * When you initially load this version of the code, you will have eight errors.
 * In the exercise in Part 2 of Chapter 29, we'll show you how to fix these.
 */
public class PrimeNumberGenerator {

	/**
	 * Method <code>generatePrimeNumbers</code> generates <code>quan</code> 
	 * prime numbers.
	 */
	public void generatePrimeNumbers() {
		ArrayList numbers = new ArrayList();
		boolean prime;
		count = 0;
		int n = 2;
		while (count < quan) {
			prime = true;
			int factor = 2;
			while (factor <= n / factor && prime) {		
				if (n % factor == 0) {
					prime = false;
				} else {
					factor++;
				}
			}
			if (prim) {
				numbers.add(new Integer(n));
				count++;
			}
			n++;
		}
		numbers.trimToSize();
		results = numbers.toArray();
	}

}
