package com.ibm.lab.usingjdt.debugging;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.ArrayList;

/**
 * Class <code>PrimeNumberGenerator</code> generates a series of prime
 * factorials starting with 2. The class is used in a number of the exercises in
 * Chapters 29 and 30 to illustrate different capabilities of the Java
 * Development Tools (JDT). Several versions of this class exist in different
 * packages in this project and in packages in other projects. These different
 * versions are used in the different parts of the exercises in chapters 29 and
 * 30.
 */
public class PrimeNumberGenerator extends NumberGenerator {
	
	/**
	 * Method <code>generateNumbers</code> generates <code>quantity</code> prime numbers.
	 */
	public void generateNumbers() {
		int count = 0;
		ArrayList numbers = new ArrayList();
		boolean prime;
		int candidate = 2;
		while (count < getQuantity()) {
			prime = true;
			int factor = 2;
			while (factor <= candidate / factor && prime) {		
				if (candidate % factor == 0) {
					prime = false;
				} else {
					factor++;
				}
			}
			if (prime) {
				numbers.add(new Integer(candidate));
				count++;
			}
			candidate++;
		}
		numbers.trimToSize();
		setResults(numbers.toArray());
	}
}
