package com.ibm.lab.usingjdt.debugging;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

/**
 * Class <code>NumberGenerator</code> is a superclass for
 * <code>PrimeNumberGenerator</code> and <code>PrimeFactorialGenerator </code>.
 * It is used in a number of the exercises in Chapters 29 and 30 to illustrate
 * different capabilities of the Java Development Tools (JDT).
 */
public class NumberGenerator {
	
	/**
	 * Method <code>generateNumbers</code> is overridden by subclasses of 
	 * <code>NumberGenerator</code> to generate specific types of numbers.
	 */
	public void generateNumbers() { }

	/**
	 * Method <code>outputResults </code> outputs the generated prime numbers.
	 * @param prefix String added to the front of each line of output. Used
	 * to distinguish output from different threads.
	 */
	public void outputResults(String prefix) {
		Date d = new Date();
		System.out.println(prefix + d.toString());
		for (int i = 0; i < getResults().length; i++) {
			System.out.println(prefix + getResults()[i]);
		}
	}

	/**
	 * Method <code>sortResults</code> sorts the numbers in reverse order.
	 * The example may seem a bit contrived. It is included to demonstrate generating
	 * inner classes.
	 */
	public void sortResults() {
		Arrays.sort(getResults(),
		new Comparator() { 
			/**
			 * @see java.util.Comparator#compare(Object, Object)
		 	*/
			public int compare(Object arg0, Object arg1) {
				if (((Integer) arg0).intValue() < ((Integer) arg1).intValue()) {
					return 1;
				} else {
					return -1;
				}
			}
		});
	}

	/**
	 * Method <code>getResults</code> returns the generated numbers.
	 * @return Object[]
	 */
	public Object[] getResults() {
		return results;
	}

	/**
	 * Method <code>setResults</code> sets the generated numbers.
	 * @param results Array of generated prime numbers
	 */
	public void setResults(Object[] results) {
		this.results = results;
	}

	/**
	 * Method <code>setQuantity</code> sets the number of numbers to generate.
	 * @param quan Number of numbers to be generated
	 */
	public void setQuantity(int quan) {
		this.quantity = quan;
	}

	/**
	 * Method <code>getQuantity</code> returns the number of numbers to generate.
	 * @return int
	 */
	public int getQuantity() {
		return quantity;
	}

	/** 
	 * Field <code>quantity</code> is the number of numbers to generate, starting
	 * with 2. 
	 */	
	protected int quantity;

	/**
	 * Field <code>results</code> contains the generated numbers.
	 */
	protected Object[] results;
}
