package com.ibm.lab.soln.resources;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * Dialog that displays a list of data in two columns.
 */
public class ListDetailsDialog extends Dialog {
  private String[] sourceList;
  private String sourceName;
  
  private String[] valueList;
  private String valueName;
  
  private String dialogTitle;

  /**
   * Constructor for ListDetailsDialog.
   * @param parentShell
   */
  public ListDetailsDialog(Shell parentShell) {
    super(parentShell);
  }

  /**
   * Constructor ListDetailsDialog. Saves the parameters for use 
   * in <code>createDialogArea()</code>.
   * @param shell - reference to caller window
   * @param title - used for list dialog
   * @param listA - first column data
   * @param listAName - first column name
   * @param listB - second column data
   * @param listBName - second column name
   */
  public ListDetailsDialog(
    Shell shell,
    String title,
    String[] listA,
    String listAName,
    String[] listB, 
        String listBName) {
    this(shell);
    dialogTitle = title;
    sourceList = listA;
    sourceName = listAName;
    valueList = listB;
    valueName = listBName;
  }

  /**
   * Creates a customized user interface. The arrays and title information
   * passed to the constructor are used to build a two column list of 
   * detailed information.
   * 
   * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(Composite)
   */
  protected Control createDialogArea(Composite parent) {
    getShell().setText(dialogTitle);
    Composite dialogArea = (Composite) super.createDialogArea(parent);

    Composite composite = new Composite(dialogArea, SWT.BORDER);

    GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 2;
    composite.setLayout(gridLayout);

    Label labelP = createLabel(composite, sourceName);
    labelP.setFont(JFaceResources.getBannerFont());
    Label labelL = createLabel(composite, valueName);
    labelL.setFont(JFaceResources.getBannerFont());

    addSpacer(composite);
    addSpacer(composite);

    for (int i = 0; i < sourceList.length; i++) {
      createLabel(composite, sourceList[i] + "  ");
      createLabel(composite, valueList[i]);
    }

    return dialogArea;
  }
  /**
   * Creates a label separator in the passed Composite.
   * @param group
   */
  private void addSpacer(Composite composite) {
    Label space = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    GridData data = new GridData(GridData.FILL_BOTH);
    space.setLayoutData(data);
  }
  /**
   * Utility method that creates a label instance
   * and sets the default layout data.
   *
   * @param parent  the parent for the new label
   * @param text  the text for the new label
   * @return the new label
   */
  private Label createLabel(Composite parent, String text) {
    Label label = new Label(parent, SWT.LEFT);
    label.setText(text);
    //	GridData data = new GridData(GridData.FILL_HORIZONTAL);;
    GridData data = new GridData(GridData.FILL_BOTH);
    //	data.horizontalSpan = 2;
    //	data.horizontalAlignment = GridData.FILL;
    label.setLayoutData(data);
    return label;
  }

}
