package com.ibm.lab.soln.resources;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Common abstract superclass for resource actions. Provides common logic to 
 * set the selected resource and display results and errors in a 
 * <code>MessageDialog</code>. A no-op stub implementation of the 
 * <code>setActivePart</code> method is also provided.
 * <p>
 * Most actions in this example expect a project as the selected resource, 
 * this logic does not care beyond expecting a structured selection.
 * </p>
 */
public abstract class ActionResourceAction
   implements IObjectActionDelegate {

   /* non-Javadoc
    * 
    * Not used in this action - implemented per interface.
    * 
    * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
    */
   public void setActivePart(
      IAction action,
      IWorkbenchPart targetPart) {
   }

   /** Holds selected project resource for run method access */
   public IStructuredSelection selection;

   /** Controls if trace stmts are written */
   boolean traceEnabled = false;

   /**
    * Used to save a local handle to the selected project resource.
    * 
    * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
    *
    * @param action action proxy that handles presentation
    * portion of the plugin action
    * @param selection current selection in the desktop
    */
   public void selectionChanged(
      IAction action,
      ISelection selection) {
      this.selection = (IStructuredSelection) selection;

   }

   /**
    * Uses a <code>MessageDialog</code> to show action results.
    * 
    * @see org.eclipse.jface.dialogs.MessageDialog
    */
   protected void resultInformation(String title, String msg) {
      // Confirm Result
      Shell shell =
         EDUResourcesPlugin
            .getDefault()
            .getWorkbench()
            .getActiveWorkbenchWindow()
            .getShell();
      MessageDialog.openInformation(shell, title, msg);
   }

   /**
    * Uses a <code>MessageDialog</code> to show errors in action processing.
    * 
    * @see org.eclipse.jface.dialogs.MessageDialog
    */
   protected void resultError(String title, String msg) {
      // Indicate Error
      Shell shell =
         EDUResourcesPlugin
            .getDefault()
            .getWorkbench()
            .getActiveWorkbenchWindow()
            .getShell();
      MessageDialog.openError(shell, title, msg);
   }

   /**
    * Uses a <code>MessageDialog</code> to show errors in action processing.
    * 
    * @see org.eclipse.jface.dialogs.MessageDialog
    */
   protected boolean resultQuestion(String title, String msg) {
      // Indicate Error
      Shell shell =
         EDUResourcesPlugin
            .getDefault()
            .getWorkbench()
            .getActiveWorkbenchWindow()
            .getShell();
      return MessageDialog.openQuestion(shell, title, msg);
   }
   /**
    * Write trace statements.  
    * System.out.println used for simplicity.
    */
   void traceMsg(String msg) {
      if (IResourceIDs.TRACE_ENABLED | traceEnabled)
         System.out.println(msg);
   }
}
