package com.ibm.lab.soln.extensionpoint;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

/**
 * Holds the parameters specified in the
 * <code>com.ibm.lab.soln.extensionpoint.toolAction</code> extension point.
 */

public class ToolActionParameters {
	private IToolAction actionClass;
	private String actionLabel;
	
	/**
	 * The constructor.
	 */
	public ToolActionParameters(IToolAction action, String label) {
		actionClass = action;
		actionLabel = label;
	}

	/**
	 * @return IToolAction 	the action
	 */
	public IToolAction getAction() {
		return actionClass;
	}
	
	/**
	 * @return String the action label
	 */
	public String getActionLabel() {
		return actionLabel;
	}
}