package com.ibm.lab.soln.interopedit.editors;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;


/**
  * In this exercise we take some existing function and incoporate it 
 * into an Eclipse-aware plug-in building on the Eclipse platform frameworks.
 * Using the Microsoft Web Browser control, we integrate that Web Browser 
 * editing capeability into an Eclipse multi-page editor using editor input 
 * from Eclipse resources and connecting custom actions to the workbench toolbar 
 * and menus. The user does not use the browser in a way to navigate to a 
 * specific document, rather the navigation occurs inside Eclipse when 
 * the user opens an *.htm file in their workspace.  When the user saves the 
 * document, all changes to the *htm file are saved in the workspace.  There is 
 * no need to refresh the workspace manually. 
 * */
public class ActiveXHTMLEditor extends MultiPageEditorPart {
	
	public static final String EDITOR_LABEL = "Soln:IE HTML Editor";

	private TextEditor editor;
	private ActiveXWebBrowser webBrowser;
	private ActiveXBrowserView webBrowserView;

	private String fileLoc;
	private static String FILE_PREFIX = "file:///";

	private boolean browserPartIsDirty = false;

	/**
	 * Constructor for ActiveXHTMLEditor.
	 */
	public ActiveXHTMLEditor() {
		super();

	}

	/**
	 * This is the method which create a text editor page and a page
	 * that hosts the IE ActiveX control.
	 * @see org.eclipse.ui.part.MultiPageEditorPart#createPages()
	 */
	protected void createPages() {
		createActiveXPage();
		createEditorPage();
		// Get the input file name
		IEditorInput input = editor.getEditorInput();
		if ((input instanceof IFileEditorInput)) {
			IFileEditorInput fileInput = (IFileEditorInput) input;
			IFile file = fileInput.getFile();
			fileLoc = FILE_PREFIX + file.getLocation().toString();
		// Open the ActiveXBrowser on the the htm file 
			if (webBrowser != null) {
				webBrowser.Navigate(fileLoc);
				webBrowser.setDesignModeProperty("On");
				webBrowser.docExecCommand("2D-Position");
				webBrowser.docExecCommand("LiveResize");
				webBrowser.docExecCommand("MultipleSelection");
			}

		}
	}
	/**
	 * Method createActiveXPage.
	 */
	private void createActiveXPage() {
		Composite composite = new Composite(getContainer(), SWT.NONE);
		webBrowserView = new ActiveXBrowserView();
		webBrowser = webBrowserView.createBrowserPartControl(composite);
		int index = addPage(composite);
		setPageText(index, EDITOR_LABEL);

	}

	/**
	 * Method createEditorPage.
	 */
	private void createEditorPage() {
		try {
			editor = new TextEditor();
			int index = addPage(editor, getEditorInput());
			setPageText(index, editor.getTitle());
		} catch (PartInitException e) {
			ErrorDialog.openError(
				getSite().getShell(),
				"Error creating nested text editor",
				null,
				e.getStatus());
		}
	}

	/**
	 * This method gets the text editor page and saves the contents.
	 * @see org.eclipse.ui.IEditorPart#doSave(IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		getEditor(1).doSave(monitor);
	}

	/**
	 * This implements a save as on the text editor input
	 * @see org.eclipse.ui.IEditorPart#doSaveAs()
	 */
	public void doSaveAs() {
		IEditorPart editor = getEditor(1);
		editor.doSaveAs();
		setPageText(0, editor.getTitle());
		setInput(editor.getEditorInput());

	}

	/**
	 * @see org.eclipse.ui.IEditorPart#gotoMarker(IMarker)
	 */
	public void gotoMarker(IMarker marker) {
	}

	/**
	 * @see org.eclipse.ui.IEditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {

		return true;
	}


	/**
	 * The <code>ActiveXHTMLEditor</code> implementation of this method
	 * checks that the input is an instance of <code>IFileEditorInput</code>.
	 * 
	 * @see org.eclipse.ui.IEditorPart#init(IEditorSite, IEditorInput)
	 *
	 */

	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {
		if (!(input instanceof IFileEditorInput))
			throw new PartInitException("Invalid Input: Must be IFileEditorInput");
		super.init(site, input);
	}

	/**
	 * This method syncronizes the contents of the text editor input and the
	 * the contents of the IE ActiveX control.
	 * @see org.eclipse.ui.part.MultiPageEditorPart#pageChange(int)
	 */
	protected void pageChange(int newPageIndex) {
		super.pageChange(newPageIndex);
		if (newPageIndex == 1) {
			// Get the contents in the browser object and set the document contents 
			resetEditorText();

		} else {
			resetBrowserText();
		}

	}

	/**
	 * Method resetBrowserText.
	 */
	private void resetBrowserText() {

		String editorText =
			editor
				.getDocumentProvider()
				.getDocument(editor.getEditorInput())
				.get();

		webBrowser.replace(editorText);

	}
	/**
	 * Method resetBrowserText.
	 */
	private void resetEditorText() {

		editor.getDocumentProvider().getDocument(editor.getEditorInput()).set(
			webBrowser.getinnerHTML());

	}

	/**
	 * A getter method to the editor page hosting the ActiveX (browser) 
	 * control.
	 */
	public ActiveXWebBrowser getBrowser() {
		return webBrowser;
	}
	/* 
	 * Returns whether the contents of this editor have changed since the last save
	 * operation. Because we are using the web browser ActiveX control,
	 * and have not yet implemented the control site listeners always report
	 * that the contents are dirty. 	 
	 *
	 * @see IEditorPart
	 */
	public boolean isDirty() {

		/*Return only if we have a webBrowser which is dirty 
		as this can be asked before anything is opened*/
		return this.webBrowser != null;
	}

}