package com.ibm.lab.soln.msseditor.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.ibm.lab.soln.msseditor.core.MiniSpreadsheetRow;

/**
 * Action to increment the selected row(s) from the mini-spreadsheet.
 */
public class IncrementRowValuesObjectActionDelegate
	implements IObjectActionDelegate {

	IStructuredSelection selection;
	
	/* non-Javadoc
	 * Constructor for IncrementRowValuesObjectActionDelegate.
	 */
	public IncrementRowValuesObjectActionDelegate() {
		super();
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * Increment each cell containing an integer.
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		for (Iterator iter = selection.iterator(); iter.hasNext();) {
			MiniSpreadsheetRow msr = (MiniSpreadsheetRow) iter.next();
			for (int i=0; i < msr.getColumnCount(); i++) {
				if (msr.isInt(i))
					msr.setData(i, msr.getInt(i)+1);
			}
		}
	}

	/**
	 * Enable the action if there is at least one cell containing an
	 * integer.
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = (IStructuredSelection) selection;
		
		for (Iterator iter = this.selection.iterator(); iter.hasNext();) {
			MiniSpreadsheetRow msr = (MiniSpreadsheetRow) iter.next();
	
			for (int i = 0; i < msr.getColumnCount(); i++) {
				if (msr.isInt(i)) {
					action.setEnabled(true);
					return;
				}
			}
		}		
		
		action.setEnabled(false);
		return;		
	}

}
