/*
 * Created on Aug 7, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.ibm.lab.newWizard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * @author PatMc
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ProjectCustomizer {

	/**
	 * 
	 */
	public ProjectCustomizer() {
		super();
		// Auto-generated constructor stub
	}

	/**
	 * Creates a folder if it does not exist, returns true if a folder
	 * was created.
	 * 
	 * @param newFolder
	 * @return boolean
	 */
	public static IFolder createFolder(IContainer container, String folderName) {

		IFolder readmeFolder = container.getFolder(new Path(folderName));

		// If the folder does not exist, create and return, failure returns null
		if (!readmeFolder.exists()) {
			try {
				readmeFolder.create(true, true, null);
				return readmeFolder;
			} catch (CoreException ce) {
				ce.printStackTrace();
				return null;
			}
		} else {
			// return what already exisited
			return readmeFolder;
		}
	}

	public static IFile createChangeLogFile(IContainer container, String fileName) {

		// if we have a container
		if (container.exists()) {
			IFile newTxtFile = container.getFile(new Path(fileName));

			// If the file does not exist, create with content, mark, and return
			if (!newTxtFile.exists()) {
				try {
					newTxtFile.create(getInitialContents(), false, null);
					addMarker(newTxtFile, container.getName());
					return newTxtFile;

					//	Failure returns null
				} catch (CoreException ce) {
					ce.printStackTrace();
					return null;
				}

			} else
				//	return what already exisited
				return newTxtFile;

		} else
			// return null as there is no container to place a file in
			return null;

	}

	/**
	 * Return input stream used to create initial file contents. 
	 */
	public static InputStream getInitialContents() {
		DateFormat dateFormatter = DateFormat.getDateInstance(DateFormat.LONG);
		Date today = new Date();
		String dateOut = dateFormatter.format(today);

		StringBuffer sb = new StringBuffer();
		sb.append("Change_log.txt\n");
		sb.append("A good place to describe your code changes.\n\n");
		sb.append("Change Date \t\t\tDescription\n");
		sb.append("--------------- \t\t--------------------------------------\n");
		sb.append(dateOut + "\t\t\tCreated Project\n ");
		sb.append("        \n ");

		return new ByteArrayInputStream(sb.toString().getBytes());
	}

	/**
	 * Add marker to identified resource. 
	 * Bookmark marker is added using predefined <code>CHAR_START</code>,
	 * <code>CHAR_END</code>, and <code>MESSAGE</code> values.
	 */
	private static void addMarker(IResource resource, String projectName) {
		try {
			IMarker marker = resource.createMarker(IMarker.BOOKMARK);
			marker.setAttribute(IMarker.LINE_NUMBER, 1);
			marker.setAttribute(IMarker.CHAR_START, 10);
			marker.setAttribute(IMarker.CHAR_END, 11);
			marker.setAttribute(IMarker.MESSAGE, projectName + ": Change Log File");
		} catch (CoreException ce) {
			ce.printStackTrace();
		}
	}

	/**
	 * Creates a file in the passed folder using content copied from
	 * a standard file found in the plug-in's install directory. 
	 * 
	 * @param folder - folder where standard image file should be created
	 */
	public static IFile copyTemplate(IFolder folder, String fileName, IPath template) {

		if (folder.exists()) {

			// create a new file in folder 
			IFile newFile = folder.getFile(fileName);

			// create the new file content using a file from the plugin install directory
			try {
				newFile.create(
					NewWizardPlugin.getDefault().openStream(template),	true,	null);
				return newFile;
				
			} catch (CoreException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			
			// can only get here if an exception was triggered
			return null;
			
		} else
			// no folder to create file in so stop
			return null;
	}

	public static void pause(long time) {
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			// Auto-generated catch block
			e.printStackTrace();
		}
	}

}
