package com.ibm.lab.soln.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * "CustomPerspective".
 * @see IPerspectiveFactory
 */
public class CustomPerspective implements IPerspectiveFactory {

	/*
	id="com.ibm.lab.soln.plugins.firstplugin.actionSet">
	id="com.ibm.lab.soln.newWizard.customProject">
	id="com.ibm.lab.soln.resourceview.resourceview">
	 */
	public static final String ID_FIRSTACTION =
		"com.ibm.lab.soln.helloworld.actionSet";
	public static final String ID_RESOURCEVIEW =
		"com.ibm.lab.soln.resourceview.resourceview";
	public static final String ID_PROJECTWIZARD =
		"com.ibm.lab.soln.newWizard.customProject";
	public static final String ID_JAVA_PERSPECTIVE =
		"org.eclipse.jdt.ui.JavaHierarchyPerspective";
	/**
	 * Implement the "CustomPerspective" constructor.
	 */
	public CustomPerspective() {
	}

	/**
	 * The initial layout of this perspective will have no editor area. 
	 * It will contain a folder in the top left area with the Resource Navigator 
	 * and Bookmarks view. It will have the Outline view below this folder. 
	 * It will also contain the Resource view under the editor area and a folder 
	 * with the Properties view and a placeholder for the Tasks view below the 
	 * Resource view.
	 * 
	 * Shortcuts for the Custom project wizard, Java perspective, and the 
	 * Tasks view have also been defined. 
	 * 
	 * @see IPerspectiveFactory#createInitialLayout
	 */
	public void createInitialLayout(IPageLayout layout) {

		// Get the editor area
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);

		// Add shortcuts
		layout.addNewWizardShortcut(ID_PROJECTWIZARD);
		layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
		layout.addPerspectiveShortcut(ID_JAVA_PERSPECTIVE);

		// Top left: Resource Navigator and Bookmarks view 
		IFolderLayout topLeft =
			layout.createFolder("topLeft", IPageLayout.LEFT, 0.3f, editorArea);
		topLeft.addView(IPageLayout.ID_RES_NAV);
		topLeft.addView(IPageLayout.ID_BOOKMARKS);

		// Bottom left: Outline view
		layout.addView(IPageLayout.ID_OUTLINE, IPageLayout.BOTTOM, 0.6f, "topLeft");

		// Right: Edu: Resource View 
		layout.addView(ID_RESOURCEVIEW, IPageLayout.BOTTOM, 0.4f, editorArea);

		// Right bottom: Property Sheet view and Tasks view placeholder
		IFolderLayout bottomRight =
			layout.createFolder(
				"bottomRight", IPageLayout.BOTTOM, 0.4f, ID_RESOURCEVIEW);
		bottomRight.addView(IPageLayout.ID_PROP_SHEET);
		bottomRight.addPlaceholder(IPageLayout.ID_TASK_LIST);

	}
}
