package com.ibm.lab.soln.serviceableplugin.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.core.runtime.*;

/**
 * This class implements an action that runs the trace 
 * @see IWorkbenchWindowActionDelegate
 */
public class TraceAction implements IWorkbenchWindowActionDelegate {
	private static final String thisClassName = "TraceAction";
	private static final String allCases = "*";
	private String traceFilter;

	/**
	 * The constructor.
	 */
	public TraceAction() {
	}

	/**
	 * Gets the tracing option and displays the actions message dialog.
	 * Also, writes to console when in debug and filter matches.
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction arg0) {

		traceFilter =
			Platform.getDebugOption(
				"com.ibm.lab.soln.extras.serviceableplugin/debug/filter");
		if ((traceFilter != null)
			&& (traceFilter.equals(allCases)
				|| traceFilter.equals(thisClassName))) {
			System.out.println("----------> TraceAction.run()");
		}
		if (ServiceablePlugin.getDefault().isDebugging())
			org.eclipse.jface.dialogs.MessageDialog.openInformation(
				(Shell) null,
				"Serviceability Example",
				"Trace message was sent.  See console or trace messages.");
		else
			org.eclipse.jface.dialogs.MessageDialog.openInformation(
				(Shell) null,
				"Serviceability Example",
				"Trace message was NOT sent. Must run under trace/debug mode.");
	}

	public void selectionChanged(IAction arg0, ISelection arg1) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow arg0) {
	}
}