package com.ibm.lab.soln.serviceableplugin.extras;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;


/**
 * The purpose of <code>ErrorDialogAction</code> is to demonstrate how to 
 * create an error dialog with error details button enabled. . 
 * @see IWorkbenchWindowActionDelegate
 */
public class ErrorDialogAction implements IWorkbenchWindowActionDelegate {
	/**
	 * The constructor.
	 */
	public ErrorDialogAction() {
	}

	/**
	 * Handles the creation and display of the errror dialog and
	 * at the same time, explicitly writes diagnostics to the error log
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		try {
			throwIt();
		} catch (ServiceException exception) {

			MultiStatus errorStatus =
				ServiceablePlugin.getDefault().getServiceInfo(exception);

			// Add in error specific info	
			String className = this.getClass().getName();
			errorStatus.add(
				new Status(
					IStatus.ERROR,
					ServiceablePlugin.getDefault().getDescriptor().getUniqueIdentifier(),
					IStatus.ERROR,
					"The error was detected in Class: " + className,
					exception));
					
			// Write to the error log		
			ServiceablePlugin.getDefault().getLog().log(errorStatus);		
			// Show an Error Dialog 
			ErrorDialog.openError(
				(Shell) null,
				"Problem Title",
				"This demonstrates an Error Message with details."
					+ "\n"
					+ "Select Details>> for more information."
					+ "\n"
					+ "See the Error Log for more information.",
				errorStatus);
		}

	}

	/**
	 * Method throwIt.
	 */
	private void throwIt() throws ServiceException {
		throw new ServiceException("Test Error Message");

	}
	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
}