package com.ibm.lab.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;

import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;

/**
 * Adapter factory to support basic UI operations for MiniSpreadsheetRow.
 * 
 * @see com.ibm.lab.soln.msseditor.core.MiniSpreadsheetRow#getAdapter(Class)
 * @see com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetUIPlugin#startup()
 */
public class MiniSpreadsheetRowActionFilterFactory implements IAdapterFactory {
	private static final IActionFilter actionFilter 
		= new MiniSpreadsheetRowActionFilter();
	
	/**
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(Object, Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType == IActionFilter.class &&
				adaptableObject instanceof MiniSpreadsheetRow) {
			return actionFilter;
		}	
		
		return null;	
	}

	/**
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	public Class[] getAdapterList() {
		return new Class[] { IActionFilter.class };
	}
}