package com.ibm.lab.msseditor.ui;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;

/**
 * Map between a mini-spreadsheet and its displayable label.
 */
public class MiniSpreadsheetLabelProvider implements ITableLabelProvider {

	/**
	 * Constructor for MiniSpreadsheetLabelProvider.
	 */
	public MiniSpreadsheetLabelProvider() {
		super();
	}

	/* non-Javadoc
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/**
	 * Return the column text corresponding to the given element; the first column
	 * is the row number.
	 * 
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		if (columnIndex == 0)
			return Integer.toString(((MiniSpreadsheetRow) element).getRowIndex() + 1);
		else			
			return ((MiniSpreadsheetRow) element).getString(columnIndex - 1);
	}

	/* non-Javadoc
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
	}

	/* non-Javadoc
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
	}

	/**
	 * Always return <code>true</code>, since all changes in the mini-spreadsheet
	 * require that the label be recalculated.
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(Object, String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		return true;
	}

	/* non-Javadoc
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
	}

}
