/*******************************************************************************
 * Template for lab exercise
 * Copyright (c) 2000, 2003 IBM Corporation.
 *******************************************************************************/
package com.ibm.lab.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MembersDialogAction implements IObjectActionDelegate {

	private ISelection selection;

	/**
		 * Constructor for Action1.
		 */
	public MembersDialogAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	//	Edu: 01  - Create dialog with a reference to the selected folder 
	public void run(IAction action) {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

		// Open dialog
		IStructuredSelection resSelection = (IStructuredSelection) selection;

		// Treat IFolder as IContainer - required by JFaceComponent
		IContainer readmeFolder = (IContainer) resSelection.getFirstElement();
		MembersDialog jdialog = new MembersDialog(shell, readmeFolder);
		jdialog.open();

		// Placeholder logic to be sure contribution works as-is
		//		MessageDialog.openInformation(shell, "TempDialog", "Placeholder Dialog");

	}

}
