package com.ibm.lab.soln.swt;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/**
 * Displays a variety of SWT controls using an Eclipse 
 * view as the container.
 */
public class SWTView extends ViewPart implements SelectionListener {

	private StyledText myText;
	private Shell workbenchShell;
	private Font font;
	static String[] ListData1 =
		{
			"Dan",
			"Jim",
			"John",
			"Pat",
			"Scott",
			"Sherry",
			"The Longest String" };

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

	/**
	 * Create the contents of the view.
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(Composite)
	 */
	public void createPartControl(Composite parent) {
		workbenchShell =
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		open(parent);
	}

	/**
	 * Populate the widgets into the view container.
	 */
	protected void open(Composite parent) {
		parent.setLayout(new org.eclipse.swt.layout.GridLayout());
		parent.setLayoutData(new GridData(GridData.GRAB_VERTICAL));

		createButtons(parent);
		createStyledText(parent);
		createList(parent);
		createProgressBar(parent);
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/**
	 * Listener for Button b1.
	 * @see SWTView#createButtons(Composite)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {

		MessageDialog.openInformation(
			null,
			"ButtonTextExample",
			"Hello World! ");
		myText.setText("Hello World");
	}

	/**
	 * Creates the buttons that display the Message and File dialogs
	 * and their selection listeners.
	 */
	public void createButtons(Composite parent) {
		Group group = new Group(parent, SWT.NONE);
		group.setLayout(new GridLayout());
		group.setText("Buttons");
		group.setLayoutData(
			new GridData(
				GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		Button b1 = new Button(group, SWT.PUSH);
		b1.setText("Show Messagebox");
		b1.setFocus();
		b1.addSelectionListener(this);

		Button b2 = new Button(group, SWT.PUSH);
		b2.setText("Show File Dialog");
		b2.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(workbenchShell, SWT.OPEN);
				dialog.setFilterExtensions(new String[] { "*.jar;*.zip" });
				String selectedFile = dialog.open();
				if (selectedFile == null)
					selectedFile = "None";
				MessageDialog.openInformation(
					null,
					"Selected File",
					selectedFile);
			}
		});
	}

	/**
	 * Creates the List widget and selection listener.
	 */
	public void createList(Composite parent) {
		Group groupList = new Group(parent, SWT.NULL);
		groupList.setLayout(new GridLayout());
		groupList.setText("List");
		groupList.setLayoutData(
			new GridData(
				GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		List myList =
			new List(
				groupList,
				SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI | SWT.BORDER);
		GridData gd = new GridData();
		// Define a 100 pixel square cell so widget displays scrollbars
		gd.heightHint = 100;
		gd.widthHint = 100;
		myList.setLayoutData(gd);
		myList.setItems(ListData1);
		myList.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				System.out.println("List item selected");
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				System.out.println("List item default selected");
			}
		});
	}

	/**
	 * Creates a rich text widget, sets its font, 
	 * and defines event listeners.
	 */
	public void createStyledText(Composite parent) {
		Group group2 = new Group(parent, SWT.NULL);
		group2.setLayout(new GridLayout());
		group2.setText("Styled Text");
		group2.setLayoutData(
			new GridData(
				GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		myText = new StyledText(group2, SWT.SINGLE | SWT.BORDER);
		myText.setText("abcdef");
		font =
			new Font(
				myText.getDisplay(),
				new FontData("Courier", 14, SWT.BOLD));
		myText.setFont(font);
		myText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				myText.setSize(90, 25);
				myText.redraw();
				System.out.println("Got new text");
			}
		});
		myText.addControlListener(new ControlListener() {
			public void controlResized(ControlEvent e) {

				System.out.println("Control Resized");
			}
			public void controlMoved(ControlEvent e) {
			}
		});
	}

	/**
	 * Basic demonstration of UI and non-UI thread synchronization.
	 * Creates a progress bar and button to run it in another thread.
	 * Progress bar is updated in the non-UI thread using Display.asyncExec method.
	 * Half way through processing the user is notified using Display.syncExec method.
	 * @see org.eclipse.swt.widgets.Display#syncExec(Runnable)
	 * @see org.eclipse.swt.widgets.Display#asyncExec(Runnable)
	 */
	public void createProgressBar(Composite parent) {
		final Display display = Display.getCurrent();
		Group groupPB = new Group(parent, SWT.NULL);
		groupPB.setLayout(new GridLayout());
		groupPB.setText("Thread Synchronization");
		groupPB.setLayoutData(
			new GridData(
				GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
		final ProgressBar bar = new ProgressBar(groupPB, SWT.SMOOTH);
		bar.setBounds(10, 10, 200, 32);
		final int maximum = bar.getMaximum();
		final Button buttonPB = new Button(groupPB, SWT.PUSH);
		final MessageDialog[] halfwayDialog = new MessageDialog[1];
		buttonPB.setText("Fill Progress Bar");
		buttonPB.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				halfwayDialog[0] =
					new MessageDialog(
						null,
						"Synchronized Dialog",
						null,
						"Halfway done!",
						MessageDialog.INFORMATION,
						new String[] { IDialogConstants.OK_LABEL },
						0);
				halfwayDialog[0].setBlockOnOpen(false);
				buttonPB.setEnabled(false);
				new Thread() {
					public void run() {
						System.out.println("Thread started");
						for (final int[] i = new int[1];
							i[0] <= maximum;
							i[0]++) {
							try {
								Thread.sleep(50);
							} catch (Throwable th) {
							}
							System.out.println("Thread processing " + i[0]);
							display.asyncExec(new Runnable() {
								public void run() {
									System.out.println(
										"Async UI interrupt " + i[0]);
									if (bar.isDisposed())
										return;
									bar.setSelection(i[0]);
								}
							});
							// inform user that halfway point reached
							if (i[0] == maximum / 2) {
								System.out.println(
									">>>>>>>>>>>>>>>>>>Halfway point");
								display.syncExec(new Runnable() {
									public void run() {
										// executing this dialog outside Display.syncExec
										// causes invalid thread access error.    
										halfwayDialog[0].open();
									}
								});
							}
							if (i[0] > (maximum * 3) / 4) {
								display.syncExec(new Runnable() {
									public void run() {
										halfwayDialog[0].close();
									}
								});
							}
						}
						System.out.println("Thread finished");
						display.syncExec(new Runnable() {
							public void run() {
								if (!buttonPB.isDisposed())
									buttonPB.setEnabled(true);
								halfwayDialog[0].close();
							}
						});
					}
				}
				.start();
			}
		});
	}

	/**
	 * Disposes of the font.
	* @see SWTView#createStyledText(Composite)
	* @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose() {
		super.dispose();
		font.dispose();
		System.out.println("Font disposed");
	}
}