package com.ibm.lab.dialogs;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * The plugin class for the Dialogs Plugin. 
 * Instantiated by the platform when the plug-in is started.
 */
public class DialogsPlugin extends AbstractUIPlugin {
   //Reference to the shared instance, returned when requested.
   private static DialogsPlugin plugin;
   //Resource bundle.
   private ResourceBundle resourceBundle;

   /**
    * The constructor.
    */
   public DialogsPlugin(IPluginDescriptor descriptor) {
      super(descriptor);
      plugin = this;
      try {
         resourceBundle =
            ResourceBundle.getBundle(
               "com.ibm.lab.dialogs.DialogsPluginResources");
      } catch (MissingResourceException x) {
         resourceBundle = null;
      }
   }

   /**
    * Returns the shared instance.
    */
   public static DialogsPlugin getDefault() {
      return plugin;
   }

   /**
    * Returns the workspace instance.
    */
   public static IWorkspace getWorkspace() {
      return ResourcesPlugin.getWorkspace();
   }

   /**
    * Returns the string from the plugin's resource bundle,
    * or 'key' if not found.
    */
   public static String getResourceString(String key) {
      ResourceBundle bundle =
         DialogsPlugin.getDefault().getResourceBundle();
      try {
         return bundle.getString(key);
      } catch (MissingResourceException e) {
         return key;
      }
   }

   /**
    * Returns the plugin's resource bundle,
    */
   public ResourceBundle getResourceBundle() {
      return resourceBundle;
   }

}
