package com.ibm.lab.soln.editor;

import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

/**
 * Example configuration for an <code>SourceViewer</code> which shows Java code.
 */
public class ReleaseEditorSourceViewerConfiguration extends SourceViewerConfiguration {


/**
 * Default constructor.
 */
public ReleaseEditorSourceViewerConfiguration() {
}
/**
 * @see ISourceViewerConfiguration#getAutoIndentStrategy
 */
public IAutoIndentStrategy getAutoIndentStrategy(Object sourcePart, String contentType) {
	return new DefaultAutoIndentStrategy();
}
	/**
	 * @see ISourceViewerConfiguration#getContentAssistant
	 */
	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {

		ContentAssistant assistant= new ContentAssistant();
		assistant.setContentAssistProcessor(new ReleaseEditorCompletionProcessor(), IDocument.DEFAULT_CONTENT_TYPE);
		
		assistant.enableAutoActivation(true);
		assistant.setAutoActivationDelay(500);
		assistant.setProposalPopupOrientation(IContentAssistant.PROPOSAL_OVERLAY);
		assistant.setContextInformationPopupOrientation(IContentAssistant.CONTEXT_INFO_ABOVE);
		
		return assistant;
	}
/**
 * @see ISourceViewerConfiguration#getContentFormatter
 */
public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
	
	ContentFormatter formatter = new ContentFormatter();
	IFormattingStrategy titleStrategy = new ReleaseEditorTitleStrategy();
	IFormattingStrategy headerStrategy = new ReleaseEditorHeaderStrategy();
	IFormattingStrategy defaultStrategy = new ReleaseEditorDefaultStrategy();
	
	formatter.setFormattingStrategy(defaultStrategy, "__release_default");
	formatter.setFormattingStrategy(headerStrategy, "__release_header");
	formatter.setFormattingStrategy(titleStrategy, "__release_title");
	
	return formatter;
}
	/**
	 * @see ISourceViewerConfiguration#getDefaultPrefix
	 */
	public String getDefaultPrefix(Object sourcePart, String contentType) {
		return (contentType == null ? "//" : null);
	}
/**
 * @see ISourceViewerConfiguration#getDoubleClickStrategy
 */
public ITextDoubleClickStrategy getDoubleClickStrategy(Object sourcePart, String contentType) {
	return null;

}
	/**
	 * @see ISourceViewerConfiguration#getIndentPrefixes
	 */
	public String[] getIndentPrefixes(Object sourcePart, String contentType) {
		return new String[] { "\t", "    " };
	}
/**
 * @see ISourceViewerConfiguration#getPresentationReconciler
 */
public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
	PresentationReconciler reconciler = new PresentationReconciler();

	DefaultDamagerRepairer dr = new DefaultDamagerRepairer(ReleaseEditor.getReleaseSEFBodyScanner());

	reconciler.setRepairer(dr, "__release_default");
	reconciler.setDamager(dr, "__release_default");
	
	dr = new DefaultDamagerRepairer(ReleaseEditor.getReleaseSEFBodyScanner());
	reconciler.setRepairer(dr, "__release_header");
	reconciler.setDamager(dr, "__release_header");

	dr = new DefaultDamagerRepairer(ReleaseEditor.getReleaseSEFBodyScanner());
	reconciler.setRepairer(dr, "__release_title");
	reconciler.setDamager(dr, "__release_title");

	return reconciler;

}
/**
 * @see ISourceViewerConfiguration#getSupportedContentTypes
 */
public String[] getSupportedContentTypes(Object sourcePart) {
	return new String[] { ReleaseEditorPartitioner.RELEASE_DEFAULT, ReleaseEditorPartitioner.RELEASE_HEADER, ReleaseEditorPartitioner.RELEASE_TITLE };

}
	/**
	 * @see ISourceViewerConfiguration#getTabWidth
	 */
	public int getTabWidth(Object sourcePart) {
		return 4;
	}
}
