package com.ibm.lab.soln.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.*;
/**
 * Insert the type's description here.
 * Creation date: (3/5/2001 2:55:11 PM)
 * @author: Administrator
 */

public class ReleaseEditorPartitioner implements IDocumentPartitioner {
	public final static String RELEASE_DEFAULT = "__release_default";
	public final static String RELEASE_TITLE = "__release_title";
	public final static String RELEASE_HEADER = "__release_header";
	private IDocument fDocument;
/**
 * ReleaseEditorPartitioner constructor comment.
 * @param colorProvider com.ibm.lab.soln.editor.ReleaseEditorColorProvider
 */
public ReleaseEditorPartitioner() {

}
/**
 * @see IDocumentPartitioner#getPartitioning
 */
public ITypedRegion[] computePartitioning(int offset, int length) {

	List list = new ArrayList();

	try {
		int start, nextOffset;
		boolean isHeader = true;
		int docLength = fDocument.getLength();

		if (offset == 0) {
			nextOffset = getLineEndOffset(0, fDocument);

			list.add(new TypedRegion(0, nextOffset + 1, RELEASE_TITLE));

			int i = 0;
			while (nextOffset + 1 < docLength - 1) {
				start = nextOffset + 1;
				if (Character.isDigit(fDocument.getChar(start)))
					isHeader = true;
				else
					isHeader = false;
				nextOffset = getLineEndOffset(i + 1, fDocument);
				if (isHeader) {
					list.add(new TypedRegion(start, nextOffset - start + 1, RELEASE_HEADER));
				} else {
					list.add(new TypedRegion(start, nextOffset - start + 1, RELEASE_DEFAULT));
				}

				i = i + 1;
			}
		} else {
			if (Character.isDigit(fDocument.getChar(offset)))
				isHeader = true;
			else
				isHeader = false;

			if (isHeader) {
				list.add(new TypedRegion(offset, length, RELEASE_HEADER));
			} else {
				list.add(new TypedRegion(offset, length, RELEASE_DEFAULT));
			}
		}

	} catch (Exception x) {
	}

	if (list.isEmpty())
		list.add(new TypedRegion(offset, length, null));

	TypedRegion[] result = new TypedRegion[list.size()];
	list.toArray(result);
	return result;
}
/**
 * @see IDocumentPartitioner#connect
 */
public void connect(IDocument document) {
	org.eclipse.jface.util.Assert.isNotNull(document);
	fDocument = document;
}
/**
 * @see IDocumentPartitioner#disconnect
 */
public void disconnect() {

}
/**
 * @see IDocumentPartitioner#documentAboutToBeChanged
 */
public void documentAboutToBeChanged(DocumentEvent e) {
}
/**
 * @see IDocumentPartitioner#documentChanged
 */
public boolean documentChanged(DocumentEvent e) {
	return false;
}
/**
 * @see IDocumentPartitioner#getContentType
 */
public String getContentType(int offset) {

	return IDocument.DEFAULT_CONTENT_TYPE;
}
/**
 * @see IDocumentPartitioner#getContentType
 */
public String [] getLegalContentTypes() {

	return null;
}
int getLineEndOffset(int line, IDocument document) throws BadLocationException {
	int length = document.getLineLength(line);
	int start = document.getLineOffset(line);
	return start + length - 1;
}
/**
 * @see IDocumentPartitioner#getPartition
 */
public ITypedRegion getPartition(int offset) {
	return new TypedRegion(0, fDocument.getLength(), RELEASE_DEFAULT);
}
}
