package com.ibm.lab.soln.editor;

/*
 * Licensed Materials - Property of IBM,
 * WebSphere Studio Workbench
 * (c) Copyright IBM Corp 2000
 */

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/**
 * Colors used in the Java editor
 */
public class ReleaseEditorColorProvider {

	public static final RGB KEYWORD = new RGB(225, 0, 0);
	public static final RGB VOWEL = new RGB(0, 128, 0);
	public static final RGB DEFAULT = new RGB(0, 0, 0);

	protected Map fColorTable = new HashMap(10);

	public void dispose() {
		Iterator e= fColorTable.values().iterator();
		while (e.hasNext())
			((Color) e.next()).dispose();
	}
	public Color getColor(RGB rgb) {
		Color color= (Color) fColorTable.get(rgb);
		if (color == null) {
			color= new Color(Display.getCurrent(), rgb);
			fColorTable.put(rgb, color);
		}
		return color;
	}
}
