package com.ibm.lab.jdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.part.*;

public class JavaMetricsView
	extends ViewPart
	implements ISelectionListener, IJavaMetricsListener {
	static final String NO_SELECTION_MESSAGE =
		"No metrics available for the current selection.";
	Text message;
	JavaMetrics jm;

	public JavaMetricsView() {
		super();
	}
	
	/*
	 * @see IWorkbenchPart#createPartControl()
	 */
	public void createPartControl(Composite parent) {
		parent.setLayout(new FillLayout());
		message = new Text(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		message.setText(NO_SELECTION_MESSAGE);
		
//		insert code here
	}

	/*
	 * @see IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
		message.setFocus();
	}

	/*
	 * @see ISelectionService#addSelectionListener
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
//		insert code here
	}

	public void dispose() {
		getViewSite().
			getWorkbenchWindow().
			getSelectionService().
			removeSelectionListener(this);
		jm.removeListener(this);			
		
		super.dispose();
	}

	private ICompilationUnit getCompilationUnit(IStructuredSelection ss) {
		if (ss.getFirstElement() instanceof IJavaElement) {
			IJavaElement je = (IJavaElement) ss.getFirstElement();
			return (ICompilationUnit) je.getAncestor(IJavaElement.COMPILATION_UNIT);
		}
		if (ss.getFirstElement() instanceof IFile) {
			IFile f = (IFile) ss.getFirstElement();
			if (f.getFileExtension() != null &&
				f.getFileExtension().compareToIgnoreCase("java") == 0)
			return (ICompilationUnit) JavaCore.create(f);
		}

		return null;
	}

	/*
	 * @see JavaMetricsListener#refresh(JavaMetrics)
	 */
	public void refresh(JavaMetrics jm) {
//		Display.getDefault().syncExec(
//			new Runnable() {		
//				insert code here and uncomment above/below
//		}});
	}
}