package com.ibm.lab.interopedit.editors;
/*
 * (c) Copyright IBM Corp. 2000, 2002.
 * All Rights Reserved.
 */


import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;


/**
 * @author scottf
 * In this exercise we take some existing function and incoporate it 
 * into an Eclipse-aware plug-in building on the Eclipse platform frameworks.
 * Using the Microsoft Web Browser control, we integrate that Web Browser 
 * editing capeability into an Eclipse multi-page editor using editor input 
 * from Eclipse resources and connecting custom actions to the workbench toolbar 
 * and menus. The user does not use the browser in a way to navigate to a 
 * specific document, rather that that navigation occurs inside Eclipse when 
 * the user opens an *.htm file in their workspace.  When the user saves the 
 * document, all changes to the *htm file in the workspace.  There is no need to 
 * refresh the workspace manually. 
 * */
public class ActiveXHTMLEditor extends MultiPageEditorPart {
	

	private TextEditor editor;

	/**
	 * Constructor for ActiveXHTMLEditor.
	 */
	public ActiveXHTMLEditor() {
		super();

	}

	/**
	 * @see org.eclipse.ui.part.MultiPageEditorPart#createPages()
	 */
	protected void createPages() {
// Add Call to create ActiveX page here

		createEditorPage();
		
// Add More ActiveX Page stuff here
// End ActiveX stuff here		
	}

	/**
	 * Method createEditorPage.
	 */
	private void createEditorPage() {
		try {
			editor = new TextEditor();
			int index = addPage(editor, getEditorInput());
			setPageText(index, editor.getTitle());
		} catch (PartInitException e) {
			ErrorDialog.openError(
				getSite().getShell(),
				"Error creating nested text editor",
				null,
				e.getStatus());
		}
	}

	/**
	 * @see org.eclipse.ui.IEditorPart#doSave(IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		getEditor(0).doSave(monitor);
	}

	/**
	 * @see org.eclipse.ui.IEditorPart#doSaveAs()
	 */
	public void doSaveAs() {
// Change getEditor(0) to getEditor(1);		
		IEditorPart editor = getEditor(0);
		editor.doSaveAs();
		setPageText(0, editor.getTitle());
		setInput(editor.getEditorInput());

	}

	/**
	 * @see org.eclipse.ui.IEditorPart#gotoMarker(IMarker)
	 */
	public void gotoMarker(IMarker marker) {
	}

	/**
	 * @see org.eclipse.ui.IEditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {

		return true;
	}


	/**
	 * @see org.eclipse.ui.IEditorPart#init(IEditorSite, IEditorInput)
	 *
	 * The <code>ActiveXHTMLEditor</code> implementation of this method
	 * checks that the input is an instance of <code>IFileEditorInput</code>.
	 */

	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {
		if (!(input instanceof IFileEditorInput))
			throw new PartInitException("Invalid Input: Must be IFileEditorInput");
		super.init(site, input);
	}

}
