package com.ibm.lab.interopedit.editors;
/*
 * (c) Copyright IBM Corp. 2000, 2002.
 * All Rights Reserved.
 */

import org.eclipse.swt.ole.win32.*;
import org.eclipse.swt.widgets.*;


/**
 * @author scottf
 * 
 * This class hosts the Shdocvw.dll component. Shdocvw.dll in turn hosts the
 * Mshtml.dll component, as well as any other Active Document component
 * (such as Word, Excel) that can be loaded in place in the browser.  The user 
 * does not use the browser in a way to navigate to a specific document, rather
 * that navigation occurs inside Eclipse when the user opens an *.htm file
 * in their workspace.  shtml/html/createwp.asp?frame=true   
 * 
 */ 
public class ActiveXBrowserView {


	private Composite displayArea;
	private OleFrame webFrame;
	private ActiveXWebBrowser webBrowser;
	private Text webUrl;
	private OleControlSite webControlSite;
	private boolean activated = false;

	/**
	 * Constructor for ActiveXBrowserView.
	 */
	public ActiveXBrowserView() {
		super();
	}



	/**
	 * Method addPropertyChangeListener.
	 * @param webControlSite
	 */
	private void addReadyStateListener(OleControlSite webControlSite) {
				// Listen for changes to the ready state and print out the current state 
		webControlSite.addPropertyListener(ActiveXWebBrowser.DISPID_READYSTATE, new OleListener() {
			public void handleEvent(OleEvent event) {
				if (event.detail == OLE.PROPERTY_CHANGING) return;
				int state = webBrowser.getReadyState();
				switch (state) {
					case ActiveXWebBrowser.READYSTATE_UNINITIALIZED:
					System.out.println("READYSTATE_UNINITIALIZED");
						
						break;
					case ActiveXWebBrowser.READYSTATE_LOADING:
					System.out.println("READYSTATE_LOADING");
					
						break;
					case ActiveXWebBrowser.READYSTATE_LOADED:
					System.out.println("READYSTATE_LOADED");
					
						break;
					case ActiveXWebBrowser.READYSTATE_INTERACTIVE:
					System.out.println("READYSTATE_INTERACTIVE");
					
						break;
					case ActiveXWebBrowser.READYSTATE_COMPLETE:
					System.out.println("READYSTATE_COMPLETE");
						break;
				}
			}
		});
	}
}
