package com.ibm.lab.interopedit;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */
import org.eclipse.jface.resource.ImageDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
/**
 * Convenience class for storing references to image descriptors
 * used by the readme tool.
 */
public class ActiveXEditorImages {
	static final URL BASE_URL = InteropeditPlugin.getDefault().getDescriptor().getInstallURL();
	public static final ImageDescriptor EDITOR_BOLD_IMAGE;
	public static final ImageDescriptor EDITOR_BOLD__DISABLED_IMAGE;
	public static final ImageDescriptor EDITOR_ITALIC_IMAGE;
	public static final ImageDescriptor EDITOR_UNDERLINE_DISABLED_IMAGE;
	public static final ImageDescriptor EDITOR_ITALIC_DISABLED_IMAGE;
	public static final ImageDescriptor EDITOR_UNDERLINE_IMAGE;
	
	 static {
		String iconPath = "icons/";
		
		EDITOR_BOLD_IMAGE = createImageDescriptor(iconPath + "bold_enabled.gif");
		EDITOR_BOLD__DISABLED_IMAGE =  createImageDescriptor(iconPath + "bold_disabled.gif");
		EDITOR_ITALIC_IMAGE = createImageDescriptor(iconPath + "italic_enabled.gif"); 
		EDITOR_UNDERLINE_IMAGE = createImageDescriptor(iconPath + "underline_enabled.gif"); 
		EDITOR_ITALIC_DISABLED_IMAGE = createImageDescriptor(iconPath + "italic_disabled.gif"); 
		EDITOR_UNDERLINE_DISABLED_IMAGE = createImageDescriptor(iconPath + "underline_disabled.gif"); 
	}
/**
 * Utility method to create an <code>ImageDescriptor</code>
 * from a path to a file.
 */
private static ImageDescriptor createImageDescriptor(String path) {
	try {
		URL url = new URL(BASE_URL, path);
		return ImageDescriptor.createFromURL(url);
	} catch (MalformedURLException e) {
	}
	return ImageDescriptor.getMissingImageDescriptor();
}
}
