package com.ibm.lab.soln.jdt.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jface.action.IAction;

/**
 * Action to add <code>private</code> modifier to <code>IMember</code>.
 */
public class MakeIMemberPrivateAction extends ChangeIMemberFlagAction {

	/**
	 * @see com.ibm.lab.soln.jdt.extras.ChangeIMemberFlagAction#performAction(IAction, IMember)
	 */
	protected boolean performAction(IAction action, IMember member) {
		boolean success =
			replaceFlag(
				member,
				Flags.AccPrivate,
				Flags.AccPublic,
				ITerminalSymbols.TokenNamepublic);
		if (!success)
			success =
				replaceFlag(
					member,
					Flags.AccPrivate,
					Flags.AccProtected,
					ITerminalSymbols.TokenNameprotected);
		if (!success)
			success = insertFlag(member, Flags.AccPrivate);

		return success;
	}

	/**
	 * @see com.ibm.lab.soln.jdt.extras.ChangeIMemberFlagAction#isChecked(IAction, IMember)
	 */
	protected boolean isChecked(IAction action, IMember member) {
		try {
			int flags = member.getFlags();
			return (flags & Flags.AccPrivate) != 0;
		} catch (JavaModelException e) {
		}

		return false;
	}
}
