package com.ibm.lab.soln.jdt.extras;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import java.util.Iterator;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * Simple view action targeted towards the views of the Java Browsing
 * perspective (Projects, Packages, Types, Members). It does nothing useful, 
 * only writes messages to the Console about the parameters and selection.
 * 
 * <p><b>Note:</b> Generally, you create a separate action delegate per
 * view in order to avoid lots of selection casting in the <code>run</code>
 * method. This example cheats (a little) by having a single action delegate
 * and testing for the selection type.
 */
public class JavaBrowsingAction implements IViewActionDelegate {
	IStructuredSelection ss;
	
	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(IViewPart)
	 */
	public void init(IViewPart view) {
		System.out.println("Start " + getClass() + ".init" + " <" + view + ">");
	}

	/**
	 * This example <code>run</code> method only prints to the Console.
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		System.out.println(
			"Start " + getClass().getName() + ".run" + " <" + action + ">");
		if (ss != null) {
			try {
				for (Iterator iter = ss.iterator(); iter.hasNext();) {
					
					// Note: Generally, you will have a separate action delegate per view type,
					// so these 'instanceof' tests are not necessary, i.e., you will
					// already know what the type of the selection must be.  But this is only
					// an example.
					//
					// Reminder: The JDT generally defines public interfaces that you should
					// reference instead of the (internal) implementation classes. The code below
					// shows some example methods that you may find interesting for your own
					// contributions.
					
					Object element = iter.next();
					
					if (element instanceof IJavaProject) {
						IJavaProject jp = (IJavaProject) element;
						System.out.println("\tJava Project (" 
							+ jp.getPackageFragmentRoots().length + ") <" 
							+ jp.getElementName() + ">");
					}
					else if (element instanceof IPackageFragment) {
						IPackageFragment pf = (IPackageFragment) element;
						if (pf.isDefaultPackage())
							System.out.println("\tPackage <" + pf.getElementName() + ">");
						else
							System.out.println("\tDefault Package <" + pf.getElementName() + ">");
					}
					else if (element instanceof IType) {
						IType t = (IType) element;
						System.out.println("\tType <" + t.getFullyQualifiedName() + ">");					
					}
					else if (element instanceof IMethod) {
						IMethod m = (IMethod) element;
						System.out.println("\tMethod (" 
							+ m.getSignature() + ") <" 
							+ m.getElementName() + ">");										
					}	
					System.out.println("\tImplementation class: " + element.getClass().getName());
				}
			} catch (JavaModelException e) {
					System.out.println("Exception in " + getClass());
					e.printStackTrace();
			}
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			ss = (IStructuredSelection) selection;
		else
			ss = null;
			
		System.out.println(
			"Start " + getClass().getName() + ".selectionChanged" + 
			" <" + action + ">" + " <" + selection.getClass() + ">");
	}
}
