package com.ibm.lab.soln.jdt;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * The purpose of <code>HelloASTAction</code> is to introduce Abstract Syntax Trees (AST)
 * and demonstrate how to process them with the <code>ASTVisitor</code> subclass, 
 * <code>ASTNode2StringVisitor</code>. This action will be shown on the window menu
 * under "Soln: Run Hello AST".
 * 
 * @see	ASTNode2StringVisitor
 * @see	org.eclipse.jdt.core.dom.ASTNode
 * @see	org.eclipse.jdt.core.dom.ASTVisitor
 * @see	org.eclipse.jdt.core.ICompilationUnit
 */
public class HelloASTAction implements IWorkbenchWindowActionDelegate {

	/**
	 * Execute the two examples: first, the AST of a "Hello, World", and
	 * then the AST of a Java source file provided by the user.
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		HelloASTAction me = new HelloASTAction();

		// Get example "Hello, World" Java source and display its AST		
		String javaCode = me.helloWorldExample();		
		CompilationUnit cu = AST.parseCompilationUnit(javaCode.toCharArray());
		ASTVisitor visitor = new ASTNode2StringVisitor();
		System.out.println(javaCode);
		cu.accept(visitor);
		
		// Get example Java source from the user and display its AST				
		javaCode = me.getJavaExample();
		cu = AST.parseCompilationUnit(javaCode.toCharArray());
		visitor = new ASTNode2StringVisitor();
		System.out.println(javaCode);
		cu.accept(visitor);
	}

	private String helloWorldExample() {
		StringBuffer sb = new StringBuffer();

		sb.append("package example;\n");
		sb.append("public class HelloWorld {\n");
		sb.append("public static void main(String[] args) {\n");
		sb.append("\t\tSystem.out.println(\"Hello World!\");\n");
		sb.append("\t}\n");
		sb.append("}");

		return sb.toString();
	}

	private String getJavaExample() {
		System.out.println("\n\nEnter a fully qualified Java filespec: ");

		try {
			String filespec =
				new BufferedReader(new InputStreamReader(System.in)).readLine();

			StringBuffer sb = new StringBuffer();

			BufferedReader reader = new BufferedReader(new FileReader(filespec));
			String line = reader.readLine();

			while (line != null) {
				sb.append(line);
				sb.append('\n');
				try {
					line = reader.readLine();
				} catch (IOException e) {
				}
			}

			reader.close();

			return sb.toString();
		} catch (IOException e) {
			System.out.println(e.getMessage());
		}

		return "";
	}
	
	/* non-Javadoc
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
	}

	/* non-Javadoc
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}