package com.ibm.lab.soln.jdt;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.jdt.core.dom.*;

/**
 * A simple <code>ASTVisitor</code> subclass that prints all nodes to the Console,
 * indented to the proper level.
 * 
 * @see	com.ibm.lab.soln.jdt.HelloASTAction
 * @see	org.eclipse.jdt.core.dom.ASTNode
 * @see	org.eclipse.jdt.core.dom.ASTVisitor
 */
public class ASTNode2StringVisitor extends ASTVisitor {

	public ASTNode2StringVisitor() {
	}

	public void preVisit(ASTNode node) {
		ASTNode tempNode = node.getParent();
		while (tempNode != null) {
			System.out.print('\t');
			tempNode = tempNode.getParent();
		}
	
		System.out.println(node.getClass());
	}
}