/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.msseditor.core;

import com.ibm.lab.msseditor.core.IMiniSpreadsheetListener;
import com.ibm.lab.msseditor.core.MiniSpreadsheetRow;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;

public class MiniSpreadsheet {
    public static final int MAX_COLUMN_COUNT = 10;
    public static final int DEFAULT_COLUMN_COUNT = 4;
    public static final int DEFAULT_ROW_COUNT = 10;
    private ListenerList listeners = new ListenerList();
    private MiniSpreadsheetRow[] rows;
    private int columnCount = 4;

    public MiniSpreadsheet(int rowCount, int columnCount) {
        ArrayList<MiniSpreadsheetRow> list = new ArrayList<MiniSpreadsheetRow>(rowCount);
        this.columnCount = Math.min(columnCount, 10);
        int i = 0;
        while (i < rowCount) {
            list.add(new MiniSpreadsheetRow(this, this.columnCount, i));
            ++i;
        }
        this.rows = new MiniSpreadsheetRow[list.size()];
        list.toArray(this.rows);
    }

    public MiniSpreadsheet(InputStream is) throws CoreException {
        this.load(is);
    }

    public void load(InputStream is) throws CoreException {
        this.setRows(this.loadRows(is));
        this.fireRowsChanged();
    }

    public String getString(int row, int column) {
        return this.rows[row].getString(column);
    }

    public int getInt(int row, int column) {
        return this.rows[row].getInt(column);
    }

    public void setData(int row, int column, String newValue) {
        this.rows[row].setData(column, newValue);
        this.fireCellChanged(row, column, newValue);
    }

    public MiniSpreadsheetRow[] getRows() {
        return this.rows;
    }

    public void addMiniSpreadsheetListener(IMiniSpreadsheetListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeMiniSpreadsheetListener(IMiniSpreadsheetListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void save(IFile file) throws CoreException {
        MiniSpreadsheetRow[] msrs = this.getRows();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < msrs.length) {
            int j = 0;
            while (j < msrs[i].getColumnCount()) {
                sb.append(String.valueOf(msrs[i].getString(j)) + ";");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        sb.append("\n");
        file.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), 2, null);
    }

    public void appendRow() {
        MiniSpreadsheetRow[] msrs = new MiniSpreadsheetRow[this.rows.length + 1];
        int i = 0;
        while (i < this.rows.length) {
            msrs[i] = this.rows[i];
            ++i;
        }
        msrs[this.rows.length] = new MiniSpreadsheetRow(this, this.getColumnCount(), this.rows.length);
        this.setRows(msrs);
    }

    public int getRowCount() {
        return this.getRows().length;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void clearAll() {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                this.setData(i, j, new String());
                ++j;
            }
            ++i;
        }
    }

    public int getTotal() {
        int total = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                total += this.getInt(i, j);
                ++j;
            }
            ++i;
        }
        return total;
    }

    protected void fireCellChanged(int row, int column, String value) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IMiniSpreadsheetListener)l[i]).valueChanged(this, row, column, value);
            ++i;
        }
    }

    private void setRows(MiniSpreadsheetRow[] msrs) {
        this.rows = msrs;
        this.fireRowsChanged();
    }

    private void fireRowsChanged() {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IMiniSpreadsheetListener)l[i]).rowsChanged(this);
            ++i;
        }
    }

    private MiniSpreadsheetRow[] loadRows(InputStream is) throws CoreException {
        ArrayList<MiniSpreadsheetRow> rows = new ArrayList<MiniSpreadsheetRow>();
        try {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            int rowIndex = 0;
            String line = lnr.readLine();
            while (line != null && line.lastIndexOf(";") > 0) {
                new StringBuffer(line);
                ArrayList<String> columns = new ArrayList<String>();
                int start = 0;
                int end = 0;
                while (end < line.length()) {
                    if (line.charAt(end) == ';') {
                        String token = line.substring(start, end);
                        columns.add(token);
                        start = end + 1;
                    }
                    ++end;
                }
                MiniSpreadsheetRow msr = new MiniSpreadsheetRow(this, columns.size(), rowIndex);
                int i = 0;
                while (i < columns.size()) {
                    msr.setData(i, (String)columns.get(i));
                    ++i;
                }
                rows.add(msr);
                ++rowIndex;
                line = lnr.readLine();
            }
            is.close();
            MiniSpreadsheetRow[] msrs = new MiniSpreadsheetRow[rows.size()];
            rows.toArray(msrs);
            this.columnCount = rows.size() == 0 ? 4 : msrs[0].getColumnCount();
            return msrs;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.lab.soln.minispreadsheet", 1, e.getLocalizedMessage(), (Throwable)e));
        }
        return null;
    }

    protected void removeRow(MiniSpreadsheetRow msr) {
        MiniSpreadsheetRow[] msrs = new MiniSpreadsheetRow[this.rows.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.rows.length) {
            if (msr == this.rows[i]) {
            } else {
                msrs[j] = this.rows[i];
                msrs[j].setRowIndex(j);
                ++j;
            }
            ++i;
        }
        this.setRows(msrs);
    }
}

