/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.newWizard.rcl;

import com.ibm.lab.newWizard.rcl.ResourceDeltaPrinter;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceChangeReporter
implements IResourceChangeListener {
    private boolean traceEnabled = true;
    String rclMode = this.rclModeDefault;
    String rclModeDefault = "RCE: ";
    int rclCount = 0;

    public ResourceChangeReporter() {
    }

    public ResourceChangeReporter(String mode) {
        this();
        this.rclMode = mode;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ++this.rclCount;
        this.traceMsg("\n" + this.rclMode + this.rclCount + " -> Event triggered...");
        switch (event.getType()) {
            case 2: {
                this.traceMsg(" -> Project " + event.getResource().getFullPath() + "  is about to close.");
                break;
            }
            case 4: {
                this.traceMsg(" -> Project " + event.getResource().getFullPath() + "  is about to be deleted.");
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                if (this.rclMode == this.rclModeDefault) break;
                this.traceMsg(" -> Auto build complete.");
                this.traceMsg(" -> Lets visit the delta...");
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaPrinter(String.valueOf(this.rclMode) + this.rclCount));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                this.traceMsg(" -> Resource has been changed.");
                try {
                    event.getResource();
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaPrinter(String.valueOf(this.rclMode) + this.rclCount));
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void traceMsg(String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(this.rclMode) + this.rclCount + msg);
        }
    }
}

