/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.newWizard;

import com.ibm.lab.soln.newWizard.NewWizardPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectCustomizer {
    public static IFolder createFolder(IContainer container, String folderName) {
        IFolder readmeFolder = container.getFolder((IPath)new Path(folderName));
        if (!readmeFolder.exists()) {
            try {
                readmeFolder.create(true, true, null);
                return readmeFolder;
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return null;
            }
        }
        return readmeFolder;
    }

    public static IFile createChangeLogFile(IContainer container, String fileName) {
        if (container.exists()) {
            IFile newTxtFile = container.getFile((IPath)new Path(fileName));
            if (!newTxtFile.exists()) {
                try {
                    newTxtFile.create(ProjectCustomizer.getInitialContents(), false, null);
                    ProjectCustomizer.addMarker((IResource)newTxtFile, container.getName());
                    return newTxtFile;
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    return null;
                }
            }
            return newTxtFile;
        }
        return null;
    }

    public static InputStream getInitialContents() {
        DateFormat dateFormatter = DateFormat.getDateInstance(1);
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        StringBuffer sb = new StringBuffer();
        sb.append("Change_log.txt\n");
        sb.append("A good place to describe your code changes.\n\n");
        sb.append("Change Date \t\t\tDescription\n");
        sb.append("--------------- \t\t--------------------------------------\n");
        sb.append(String.valueOf(dateOut) + "\t\t\tCreated Project\n ");
        sb.append("        \n ");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private static void addMarker(IResource resource, String projectName) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("charStart", 10);
            marker.setAttribute("charEnd", 11);
            marker.setAttribute("message", (Object)(String.valueOf(projectName) + ": Change Log File"));
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public static IFile copyTemplate(IFolder folder, String fileName, IPath template) {
        if (folder.exists()) {
            IFile newFile = folder.getFile(fileName);
            try {
                newFile.create(NewWizardPlugin.getDefault().openStream(template), true, null);
                return newFile;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    public static void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

