/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.extensionpoint;

import com.ibm.lab.soln.extensionpoint.IToolAction;
import com.ibm.lab.soln.extensionpoint.ToolActionParameters;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionProcessor {
    private static final String PLUGIN_ID = "com.ibm.lab.soln.extensionpoint";
    private static final String EXTENSION_POINT_ID = "toolAction";
    private static final String EXTENSION_TAG = "tool";
    private static final String EXTENSION_TAG_ACTION_ATTRIB = "action";
    private static final String EXTENSION_TAG_LABEL_ATTRIB = "label";
    private IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
    private IExtensionPoint point = this.pluginRegistry.getExtensionPoint("com.ibm.lab.soln.extensionpoint", "toolAction");
    private List toolActionsParameters = new ArrayList();

    protected List getToolActionsParameters() {
        return this.toolActionsParameters;
    }

    private void addMenuItem(IConfigurationElement configElement) {
        System.out.print("Loading tag...");
        try {
            IToolAction toolAction = (IToolAction)configElement.createExecutableExtension(EXTENSION_TAG_ACTION_ATTRIB);
            String label = configElement.getAttribute(EXTENSION_TAG_LABEL_ATTRIB);
            boolean doubleEntry = false;
            int i = 0;
            while (i < this.getToolActionsParameters().size()) {
                ToolActionParameters toolActionParameters = (ToolActionParameters)this.getToolActionsParameters().get(i);
                if (toolActionParameters.getActionLabel().equals(label)) {
                    doubleEntry = true;
                }
                ++i;
            }
            if (!doubleEntry) {
                this.getToolActionsParameters().add(new ToolActionParameters(toolAction, label));
                System.out.println("...success!");
            } else {
                System.out.println("...failed! Reason: Label '" + label + "' already exists.  Check your plugin.xml");
            }
            System.out.println("Details: action: " + configElement.getAttribute(EXTENSION_TAG_ACTION_ATTRIB) + ", " + EXTENSION_TAG_LABEL_ATTRIB + ": " + configElement.getAttribute(EXTENSION_TAG_LABEL_ATTRIB));
        }
        catch (CoreException e) {
            System.out.print("...failed! Reason: " + e.getLocalizedMessage());
        }
    }

    public void load() {
        System.out.println("*Action Configuration Start*");
        if (this.point != null) {
            IExtension[] extensions = this.point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                IConfigurationElement[] tags = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < tags.length) {
                    IConfigurationElement currentTag = tags[j];
                    if (currentTag.getName().equals(EXTENSION_TAG)) {
                        this.addMenuItem(currentTag);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.point == null || this.getToolActionsParameters().size() == 0) {
            System.out.println("* No configuration found!");
        }
        System.out.println("*Action Configuration End*");
    }
}

