/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.jdt;

import com.ibm.lab.jdt.IJavaMetricsListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IWorkingCopy;

public class JavaMetrics {
    private int methodDeclarationCount;
    private int fieldDeclarationCount;
    private int stringLiteralCount;
    private ICompilationUnit cu;
    private List listeners = new ArrayList();

    public JavaMetrics() {
        this.reset(null);
    }

    public void reset(ICompilationUnit newcu) {
        this.cu = newcu;
        this.methodDeclarationCount = 0;
        this.fieldDeclarationCount = 0;
        this.stringLiteralCount = 0;
        this.notifyListeners();
    }

    public void addListener(IJavaMetricsListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IJavaMetricsListener listener) {
        this.listeners.remove(listener);
    }

    private IJavaElementDelta findJavaElementDelta(IJavaElementDelta parentJed, IJavaElement je) {
        IJavaElementDelta jed = parentJed;
        IJavaElement je2 = parentJed.getElement();
        if (je2 instanceof IWorkingCopy && ((IWorkingCopy)je2).isWorkingCopy()) {
            je2 = ((IWorkingCopy)je2).getOriginalElement();
        }
        if (je.equals(je2)) {
            return parentJed;
        }
        int i = 0;
        while (i < parentJed.getAffectedChildren().length) {
            jed = this.findJavaElementDelta(parentJed.getAffectedChildren()[i], je);
            if (jed != null) {
                return jed;
            }
            ++i;
        }
        return null;
    }

    private void notifyListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IJavaMetricsListener listener = (IJavaMetricsListener)iterator.next();
            listener.refresh(this);
        }
    }

    public int getMethodDeclarationCount() {
        return this.methodDeclarationCount;
    }

    public int getFieldDeclarationCount() {
        return this.fieldDeclarationCount;
    }

    public int getStringLiteralCount() {
        return this.stringLiteralCount;
    }

    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# Methods = " + this.getMethodDeclarationCount() + "\n");
        sb.append("# Fields = " + this.getFieldDeclarationCount() + "\n");
        sb.append("# String Literals = " + this.getStringLiteralCount() + "\n");
        return sb.toString();
    }

    public boolean hasValidMetrics() {
        return this.cu != null;
    }
}

