/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.swing.internalApplication;

import com.ibm.lab.soln.swing.internalLaunch.extras.SwingEditorPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ABCEditor
extends JFrame {
    static Set openFiles = Collections.synchronizedSet(new HashSet());
    private IFile eclipseEditorInput;
    private static final int maxURLCount = 10;
    private JPanel rootPanel = null;
    private JMenuBar menuBar = null;
    private JToolBar toolBar = null;
    private Action fileOpenAction = new FileOpenAction();
    private Action fileSaveAction = new FileSaveAction();
    private Action addSomeTextAction = new AddSomeTextAction();
    private File input = new File("newFile");
    private JTextArea contents = null;
    private boolean runStandAlone;

    public void openOnEclipseFile(IFile eclipseFileResource) {
        this.eclipseEditorInput = eclipseFileResource;
        this.runStandAlone = false;
        this.open(new File(eclipseFileResource.getLocation().toString()));
        this.fileOpenAction.setEnabled(false);
    }

    public ABCEditor(String fileName) {
        super(fileName);
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.toolBar = this.createToolBar();
        this.rootPanel.add((Component)this.toolBar, "North");
        this.contents = new JTextArea();
        this.contents.setLineWrap(true);
        this.rootPanel.add((Component)new JScrollPane(this.contents), "Center");
        this.rootPanel.setPreferredSize(new Dimension(400, 200));
        this.getContentPane().add(this.rootPanel);
        this.pack();
        ((Component)this).setLocation(new Point(100, 80));
        ((Component)this).setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we_Event) {
                try {
                    SwingEditorPlugin.getDefault().saveWorkspace();
                }
                catch (CoreException coreException) {}
                if (ABCEditor.this.runStandAlone) {
                    System.exit(0);
                }
            }
        });
    }

    public ABCEditor() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.getFileMenu());
        return this.menuBar;
    }

    public JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEtchedBorder());
        JButton button = null;
        button = toolBar.add(this.fileOpenAction);
        button.setText("Open");
        button.setToolTipText("Open a .abc file");
        button = toolBar.add(this.fileSaveAction);
        button.setText("Save");
        button.setToolTipText("save this .abc file");
        toolBar.addSeparator();
        button = toolBar.add(this.addSomeTextAction);
        button.setText("Add");
        button.setToolTipText("press this button to add some text");
        return toolBar;
    }

    protected JMenu getFileMenu() {
        JMenu fileMenu = new JMenu("File", true);
        JMenuItem menuItem = null;
        menuItem = fileMenu.add(this.fileOpenAction);
        menuItem.setText("Open...");
        menuItem.setMnemonic('O');
        fileMenu.addSeparator();
        menuItem = fileMenu.add(this.fileSaveAction);
        menuItem.setText("Save");
        menuItem.setMnemonic('S');
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('E');
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ABCEditor.this.runStandAlone) {
                    System.exit(0);
                } else {
                    ((Component)ABCEditor.this).setVisible(false);
                    ABCEditor.this.dispose();
                }
            }
        });
        fileMenu.add(menuItem);
        return fileMenu;
    }

    public static final void main(String[] argv) {
        if (argv.length > 1) {
            System.out.println("Usage: java ABCEditor <fileName>.abc");
            System.exit(1);
        }
        String fileName = "newFile.abc";
        if (argv.length == 1) {
            fileName = argv[0];
        }
        ABCEditor editor = new ABCEditor("External Launch ABC Editor");
        editor.setRunStandAlone(true);
        editor.open(new File(fileName));
    }

    public boolean open(File file) {
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(new FileReader(file));
            while ((s = in.readLine()) != null) {
                this.contents.append(s);
                this.contents.append("\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        this.input = file;
        this.setTitle("ABC Edit: " + this.input.getName());
        return true;
    }

    public void save() {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.input));
            out.write(this.contents.getText());
            SwingEditorPlugin.getDefault().updateWorkspace(this.eclipseEditorInput);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private void setRunStandAlone(boolean runStandAlone) {
        this.runStandAlone = runStandAlone;
    }

    public class FileOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            String fileName = null;
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(ABCEditor.this);
            if (returnVal == 0) {
                fileName = chooser.getSelectedFile().getName();
                ABCEditor.this.open(new File(fileName));
            }
        }
    }

    public class FileSaveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            ABCEditor.this.save();
        }
    }

    public class AddSomeTextAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            ABCEditor.this.contents.append("this is new contents\n");
        }
    }
}

