/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources;

import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import com.ibm.lab.soln.resources.ResourceDeltaPrinter;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;

public class ResourceChangeReporter
implements IResourceChangeListener {
    private boolean traceEnabled = false;
    String rclMode = this.rclModeDefault;
    String rclModeDefault = "RCE: ";
    int rclCount = 0;

    public ResourceChangeReporter() {
    }

    public ResourceChangeReporter(String mode) {
        this();
        this.rclMode = mode;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ++this.rclCount;
        this.traceMsg("\n" + this.rclMode + this.rclCount + " -> Event triggered...");
        switch (event.getType()) {
            case 2: {
                this.traceMsg(" -> Project " + event.getResource().getFullPath() + "  is about to close.");
                this.propTwist();
                break;
            }
            case 4: {
                this.traceMsg(" -> Project " + event.getResource().getFullPath() + "  is about to be deleted.");
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                if (this.rclMode == this.rclModeDefault) break;
                this.traceMsg(" -> Auto build complete.");
                this.traceMsg(" -> Lets visit the delta...");
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaPrinter(String.valueOf(this.rclMode) + this.rclCount));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                this.traceMsg(" -> Resource has been changed.");
                try {
                    event.getResource();
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaPrinter(String.valueOf(this.rclMode) + this.rclCount));
                    break;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void traceMsg(String msg) {
        System.out.println(String.valueOf(this.rclMode) + this.rclCount + msg);
    }

    void propTwist() {
        IPreferenceStore myPS = EDUResourcesPlugin.getDefault().getPreferenceStore();
        myPS.setValue("Pre_Close_key", "updated in RCL");
    }
}

