/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jdt;

import com.ibm.lab.soln.jdt.IJavaMetricsListener;
import com.ibm.lab.soln.jdt.JavaMetrics;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class JavaMetricsView
extends ViewPart
implements ISelectionListener,
IJavaMetricsListener {
    static final String NO_SELECTION_MESSAGE = "No metrics available for the current selection.";
    Text message;
    JavaMetrics jm;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.message = new Text(parent, 770);
        this.message.setText(NO_SELECTION_MESSAGE);
        this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.jm = new JavaMetrics();
        this.jm.addListener(this);
    }

    public void setFocus() {
        this.message.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ICompilationUnit cu = this.getCompilationUnit((IStructuredSelection)selection);
            this.jm.reset(cu);
        }
    }

    public void dispose() {
        this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.jm.removeListener(this);
        super.dispose();
    }

    private ICompilationUnit getCompilationUnit(IStructuredSelection ss) {
        IFile f;
        if (ss.getFirstElement() instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)ss.getFirstElement();
            return (ICompilationUnit)je.getAncestor(5);
        }
        if (ss.getFirstElement() instanceof IFile && (f = (IFile)ss.getFirstElement()).getFileExtension() != null && f.getFileExtension().compareToIgnoreCase("java") == 0) {
            return (ICompilationUnit)JavaCore.create((IFile)f);
        }
        return null;
    }

    public void refresh(JavaMetrics unused) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (JavaMetricsView.this.jm.hasValidMetrics()) {
                    JavaMetricsView.this.message.setText(JavaMetricsView.this.jm.summaryString());
                } else {
                    JavaMetricsView.this.message.setText(JavaMetricsView.NO_SELECTION_MESSAGE);
                }
            }
        });
    }
}

