/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.jdt;

import com.ibm.lab.soln.jdt.IJavaMetricsListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaMetrics
implements IElementChangedListener {
    private int methodDeclarationCount;
    private int fieldDeclarationCount;
    private int stringLiteralCount;
    private ICompilationUnit cu;
    private List listeners = new ArrayList();

    public JavaMetrics() {
        this.reset(null);
    }

    public void reset(ICompilationUnit newcu) {
        this.cu = newcu;
        this.methodDeclarationCount = 0;
        this.fieldDeclarationCount = 0;
        this.stringLiteralCount = 0;
        if (this.cu != null) {
            new JavaMetricsAccumulator(this, this.cu);
            if (this.cu.isWorkingCopy()) {
                this.cu = (ICompilationUnit)this.cu.getOriginalElement();
            }
        }
        this.notifyListeners();
    }

    public void addListener(IJavaMetricsListener listener) {
        this.listeners.add(listener);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void removeListener(IJavaMetricsListener listener) {
        this.listeners.remove(listener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.cu == null) {
            return;
        }
        ICompilationUnit changedCu = (ICompilationUnit)event.getDelta().getElement().getAncestor(5);
        if (changedCu == null) {
            return;
        }
        ICompilationUnit originalCu = changedCu instanceof IWorkingCopy && ((IWorkingCopy)changedCu).isWorkingCopy() ? (ICompilationUnit)((IWorkingCopy)changedCu).getOriginalElement() : changedCu;
        if (this.cu.equals(originalCu)) {
            if (event.getDelta().getKind() != 2) {
                this.reset(changedCu);
            } else {
                this.reset(null);
            }
        }
    }

    private void notifyListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IJavaMetricsListener listener = (IJavaMetricsListener)iterator.next();
            listener.refresh(this);
        }
    }

    protected boolean processStringLiteral(StringLiteral node) {
        ++this.stringLiteralCount;
        return false;
    }

    protected boolean processFieldDeclaration(FieldDeclaration node) {
        ++this.fieldDeclarationCount;
        return false;
    }

    protected boolean processMethodDeclaration(MethodDeclaration node) {
        ++this.methodDeclarationCount;
        return true;
    }

    public int getMethodDeclarationCount() {
        return this.methodDeclarationCount;
    }

    public int getFieldDeclarationCount() {
        return this.fieldDeclarationCount;
    }

    public int getStringLiteralCount() {
        return this.stringLiteralCount;
    }

    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.cu.getElementName()) + "\n\n");
        sb.append("# Methods = " + this.getMethodDeclarationCount() + "\n");
        sb.append("# Fields = " + this.getFieldDeclarationCount() + "\n");
        sb.append("# String Literals = " + this.getStringLiteralCount() + "\n");
        return sb.toString();
    }

    public boolean hasValidMetrics() {
        return this.cu != null;
    }

    private class JavaMetricsAccumulator
    extends ASTVisitor {
        private JavaMetrics jm;

        public JavaMetricsAccumulator(JavaMetrics newJm, ICompilationUnit newCu) {
            this.jm = newJm;
            AST.parseCompilationUnit((ICompilationUnit)newCu, (boolean)false).accept((ASTVisitor)this);
        }

        public boolean visit(StringLiteral node) {
            return this.jm.processStringLiteral(node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.jm.processFieldDeclaration(node);
        }

        public boolean visit(MethodDeclaration node) {
            return this.jm.processMethodDeclaration(node);
        }
    }
}

