/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.util.Assert;

public class ReleaseEditorPartitioner
implements IDocumentPartitioner {
    public static final String RELEASE_DEFAULT = "__release_default";
    public static final String RELEASE_TITLE = "__release_title";
    public static final String RELEASE_HEADER = "__release_header";
    private IDocument fDocument;

    public ITypedRegion[] computePartitioning(int offset, int length) {
        ArrayList<TypedRegion> list = new ArrayList<TypedRegion>();
        try {
            boolean isHeader = true;
            int docLength = this.fDocument.getLength();
            if (offset == 0) {
                int nextOffset = this.getLineEndOffset(0, this.fDocument);
                list.add(new TypedRegion(0, nextOffset + 1, RELEASE_TITLE));
                int i = 0;
                while (nextOffset + 1 < docLength - 1) {
                    int start = nextOffset + 1;
                    isHeader = Character.isDigit(this.fDocument.getChar(start));
                    nextOffset = this.getLineEndOffset(i + 1, this.fDocument);
                    if (isHeader) {
                        list.add(new TypedRegion(start, nextOffset - start + 1, RELEASE_HEADER));
                    } else {
                        list.add(new TypedRegion(start, nextOffset - start + 1, RELEASE_DEFAULT));
                    }
                    ++i;
                }
            } else {
                isHeader = Character.isDigit(this.fDocument.getChar(offset));
                if (isHeader) {
                    list.add(new TypedRegion(offset, length, RELEASE_HEADER));
                } else {
                    list.add(new TypedRegion(offset, length, RELEASE_DEFAULT));
                }
            }
        }
        catch (Exception exception) {}
        if (list.isEmpty()) {
            list.add(new TypedRegion(offset, length, null));
        }
        TypedRegion[] result = new TypedRegion[list.size()];
        list.toArray(result);
        return result;
    }

    public void connect(IDocument document) {
        Assert.isNotNull((Object)document);
        this.fDocument = document;
    }

    public void disconnect() {
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
    }

    public boolean documentChanged(DocumentEvent e) {
        return false;
    }

    public String getContentType(int offset) {
        return "__dftl_partition_content_type";
    }

    public String[] getLegalContentTypes() {
        return null;
    }

    int getLineEndOffset(int line, IDocument document) throws BadLocationException {
        int length = document.getLineLength(line);
        int start = document.getLineOffset(line);
        return start + length - 1;
    }

    public ITypedRegion getPartition(int offset) {
        return new TypedRegion(0, this.fDocument.getLength(), RELEASE_DEFAULT);
    }
}

